#!/usr/bin/env sh

unset CDPATH

EXECUTOR_FILE_NAME="tool-executor.jar"
EXECUTOR_SUB_DIR="tool"
SCRIPT_FILE_NAME="$0"

# SCRIPT may be an arbitrarily deep series of symlinks. Loop until we have the concrete path.
while [ -h "$SCRIPT_FILE_NAME" ] ; do
    ls=`ls -ld "$SCRIPT_FILE_NAME"`
    # Drop everything prior to ->
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '/.*' > /dev/null; then
        SCRIPT_FILE_NAME="$link"
    else
        SCRIPT_FILE_NAME=`dirname "$SCRIPT_FILE_NAME"`/"$link"
    fi
done

# Determine home absolute path
SCRIPT_HOME=`dirname "$SCRIPT_FILE_NAME"`
SCRIPT_HOME=`cd "$SCRIPT_HOME"; pwd`
DRY_RUN_MARKER="|"

# This is to avoid following symlinks.
ORIGINAL_DIR=$(pwd)
cd ${SCRIPT_HOME}
cd ..
export APPLICATION_HOME=$(pwd)
cd ${ORIGINAL_DIR}

os_name=$(uname -s)


execute() {
    if  [ "start" = $1 ];
    then
        # If start command, then run it in dry run mode and get the arguments from the executor.
        # We will then execute the program directly using exec and avoid the need for the executor
        # JVM from lingering.

        DRY_RUN_STR=$("$JAVA_CMD" -jar "$SCRIPT_HOME"/"$EXECUTOR_SUB_DIR"/"$EXECUTOR_FILE_NAME" "$@" -dr "$DRY_RUN_MARKER"  2>&1 \
        		  | if [ -w /dev/stderr ] ; then tee /dev/stderr ; else cat - ; fi \
        		  | awk -v marker=$DRY_RUN_MARKER -F${DRY_RUN_MARKER} '{for (i = 2; i <= NF; i++) { printf("%s%s", $i, marker) } }'
        )
        if [ ! -z $DRY_RUN_STR ];
        then
        	ORIG_IFS=$IFS
        	IFS=$DRY_RUN_MARKER
        	DRY_RUN_STR_SPACE_SEPARATED=`echo $DRY_RUN_STR | sed "s/|/ /"`
        	IFS=$ORIG_IFS
        	echo ""
        	eval exec "$JAVA_CMD" "${DRY_RUN_STR_SPACE_SEPARATED}"
        fi
        exit 1
    else
        exec "$JAVA_CMD" -jar "$SCRIPT_HOME"/"$EXECUTOR_SUB_DIR"/"$EXECUTOR_FILE_NAME" "$@"
    fi
}

setJavaCmd () {
    if [ -z "$JAVA_HOME" ]; then
        JAVA_HOME="$APPLICATION_HOME/jre/zulu-17.jre/Contents/Home/"
    fi

    if [ ! -d "$JAVA_HOME" ]; then
        # If the specific path does not exist, assign "$HOME/jre/" to JAVA_HOME
        JAVA_HOME="$APPLICATION_HOME/jre"
    fi

    # Check if JAVA_CMD is a valid command in this new JAVA_HOME
    if [ -x "$JAVA_HOME/bin/java" ]; then
        JAVA_CMD="$JAVA_HOME/bin/java"
    else
        JAVA_CMD=$(which java)
    fi
}

setJavaCmd
[ "$JAVA_CMD" ] && execute $@
echo "Please set JAVA_HOME env variable"
exit 1
