' ========================================================
'
' Monitors CPU, Memory, Network and Disks on Windows
'
' version 1.1
'
' ========================================================
Option Explicit

' --- Object references ---
Dim oWsh, objWMIService, objRefresher
Dim ColCPU, ColMemPh, ColMem, ColDisk, ColNet
Dim objItem

' --- Time control ---
Dim NET_TIME, netTimeRelative, notFirstIteration
Dim startTime, endTime, timeDiff

' --- CPU ---
Dim CPU_IDLE, CPU_BUSY

' --- Memory ---
Dim MEM_TOTAL_MB, MEM_FREE_MB, MEM_USED_MB, MEM_USED_PC, MEM_FREE_PC

' --- Network ---
Dim NET_PACKETS_IN, NET_PACKETS_OUT, NET_KBYTES_IN, NET_KBYTES_OUT
Dim TMP_NET_PACKETS1_IN, TMP_NET_PACKETS1_OUT, TMP_NET_BYTES1_IN, TMP_NET_BYTES1_OUT
Dim TMP_NET_PACKETS2_IN, TMP_NET_PACKETS2_OUT, TMP_NET_BYTES2_IN, TMP_NET_BYTES2_OUT

' --- Disk ---
Dim READS, WRITES, READS_KB, WRITES_KB
Dim TMP_READS1, TMP_WRITES1, TMP_READS1_KB, TMP_WRITES1_KB
Dim TMP_READS2, TMP_WRITES2, TMP_READS2_KB, TMP_WRITES2_KB

' --- Initialization ---
NET_TIME = 60
netTimeRelative = NET_TIME
notFirstIteration = 0

Set oWsh = WScript.CreateObject("WScript.Shell")
Set objWMIService = GetObject("winmgmts:\\.\root\CIMV2")
Set objRefresher = CreateObject("WbemScripting.SWbemRefresher")

Set ColCPU = objRefresher.Add(objWMIService,"Win32_PerfFormattedData_PerfOS_Processor.Name='_Total'").Object
Set ColMemPh = objRefresher.AddEnum(objWMIService,"Win32_ComputerSystem").ObjectSet
Set ColMem = objRefresher.AddEnum(objWMIService,"Win32_PerfFormattedData_PerfOS_Memory").ObjectSet

' --- Initial zeroed previous values ---
TMP_NET_PACKETS1_IN = 0 : TMP_NET_PACKETS1_OUT = 0 : TMP_NET_BYTES1_IN = 0 : TMP_NET_BYTES1_OUT = 0
TMP_READS1 = 0 : TMP_WRITES1 = 0 : TMP_READS1_KB = 0 : TMP_WRITES1_KB = 0

Do
	objRefresher.Refresh

	' --- Collect disk ---
	Set ColDisk = objWMIService.ExecQuery("SELECT * FROM Win32_PerfRawData_PerfDisk_PhysicalDisk WHERE Name='_Total'")
	For Each objItem In ColDisk
		TMP_READS2 = objItem.DiskReadsPersec
		TMP_WRITES2 = objItem.DiskWritesPersec
		TMP_READS2_KB = objItem.DiskReadBytesPersec / 1024
		TMP_WRITES2_KB = objItem.DiskWriteBytesPersec / 1024
	Next

	' --- Collect network ---
	Set ColNet = objWMIService.ExecQuery("SELECT * FROM Win32_PerfRawData_Tcpip_NetworkInterface")
	TMP_NET_PACKETS2_IN = 0 : TMP_NET_PACKETS2_OUT = 0 : TMP_NET_BYTES2_IN = 0 : TMP_NET_BYTES2_OUT = 0
	For Each objItem In ColNet
		TMP_NET_PACKETS2_IN = TMP_NET_PACKETS2_IN + objItem.PacketsReceivedPersec
		TMP_NET_PACKETS2_OUT = TMP_NET_PACKETS2_OUT + objItem.PacketsSentPersec
		TMP_NET_BYTES2_IN = TMP_NET_BYTES2_IN + objItem.BytesReceivedPersec
		TMP_NET_BYTES2_OUT = TMP_NET_BYTES2_OUT + objItem.BytesSentPersec
	Next

	' --- Calculate deltas ---
	NET_PACKETS_IN = Round((TMP_NET_PACKETS2_IN - TMP_NET_PACKETS1_IN) / netTimeRelative)
	NET_PACKETS_OUT = Round((TMP_NET_PACKETS2_OUT - TMP_NET_PACKETS1_OUT) / netTimeRelative)
	NET_KBYTES_IN = Round((TMP_NET_BYTES2_IN - TMP_NET_BYTES1_IN) / netTimeRelative / 1024)
	NET_KBYTES_OUT = Round((TMP_NET_BYTES2_OUT - TMP_NET_BYTES1_OUT) / netTimeRelative / 1024)

	READS = Round((TMP_READS2 - TMP_READS1) / netTimeRelative)
	WRITES = Round((TMP_WRITES2 - TMP_WRITES1) / netTimeRelative)
	READS_KB = Round((TMP_READS2_KB - TMP_READS1_KB) / netTimeRelative)
	WRITES_KB = Round((TMP_WRITES2_KB - TMP_WRITES1_KB) / netTimeRelative)

	' --- CPU ---
	CPU_BUSY = ColCPU.PercentProcessorTime
	CPU_IDLE = 100 - CPU_BUSY

	' --- Memory ---
	For Each objItem In ColMemPh
		MEM_TOTAL_MB = Round(objItem.TotalPhysicalMemory / (1024 * 1024))
	Next
	For Each objItem In ColMem
		MEM_FREE_MB = objItem.AvailableMbytes
	Next
	MEM_USED_MB = MEM_TOTAL_MB - MEM_FREE_MB
	If MEM_TOTAL_MB > 0 Then
		MEM_USED_PC = Round((MEM_USED_MB * 100) / MEM_TOTAL_MB)
	Else
		MEM_USED_PC = 0
	End If
	MEM_FREE_PC = 100 - MEM_USED_PC

	' --- Output ---
	If notFirstIteration Then
		WScript.Echo "name=Hardware Resources|CPU|%Idle,aggregator=OBSERVATION,value=" & CPU_IDLE
		WScript.Echo "name=Hardware Resources|CPU|%Busy,aggregator=OBSERVATION,value=" & CPU_BUSY
		WScript.Echo "name=Hardware Resources|Memory|Total (MB),aggregator=OBSERVATION,value=" & MEM_TOTAL_MB
		WScript.Echo "name=Hardware Resources|Memory|Used (MB),aggregator=OBSERVATION,value=" & MEM_USED_MB
		WScript.Echo "name=Hardware Resources|Memory|Free (MB),aggregator=OBSERVATION,value=" & MEM_FREE_MB
		WScript.Echo "name=Hardware Resources|Memory|Used %,aggregator=OBSERVATION,value=" & MEM_USED_PC
		WScript.Echo "name=Hardware Resources|Memory|Free %,aggregator=OBSERVATION,value=" & MEM_FREE_PC
		WScript.Echo "name=Hardware Resources|Network|Incoming packets/sec,aggregator=OBSERVATION,value=" & NET_PACKETS_IN
		WScript.Echo "name=Hardware Resources|Network|Outgoing packets/sec,aggregator=OBSERVATION,value=" & NET_PACKETS_OUT
		WScript.Echo "name=Hardware Resources|Network|Incoming KB/sec,aggregator=OBSERVATION,value=" & NET_KBYTES_IN
		WScript.Echo "name=Hardware Resources|Network|Outgoing KB/sec,aggregator=OBSERVATION,value=" & NET_KBYTES_OUT
		WScript.Echo "name=Hardware Resources|Disks|Reads/sec,aggregator=OBSERVATION,value=" & READS
		WScript.Echo "name=Hardware Resources|Disks|Writes/sec,aggregator=OBSERVATION,value=" & WRITES
		WScript.Echo "name=Hardware Resources|Disks|KB read/sec,aggregator=OBSERVATION,value=" & READS_KB
		WScript.Echo "name=Hardware Resources|Disks|KB written/sec,aggregator=OBSERVATION,value=" & WRITES_KB

		endTime = Now
		timeDiff = DateDiff("s", startTime, endTime)
		If timeDiff < NET_TIME Then
			netTimeRelative = NET_TIME
			WScript.Sleep ((NET_TIME - timeDiff) * 1000)
		Else
			netTimeRelative = timeDiff
		End If
	Else
		WScript.Sleep(NET_TIME * 1000)
	End If

	' --- Update previous values ---
	TMP_NET_PACKETS1_IN = TMP_NET_PACKETS2_IN
	TMP_NET_PACKETS1_OUT = TMP_NET_PACKETS2_OUT
	TMP_NET_BYTES1_IN = TMP_NET_BYTES2_IN
	TMP_NET_BYTES1_OUT = TMP_NET_BYTES2_OUT
	TMP_READS1 = TMP_READS2
	TMP_WRITES1 = TMP_WRITES2
	TMP_READS1_KB = TMP_READS2_KB
	TMP_WRITES1_KB = TMP_WRITES2_KB

	startTime = Now
	notFirstIteration = 1
Loop
WScript.Quit