'
' Copyright (c) AppDynamics, Inc., and its affiliates, 2014, 2015
' All Rights Reserved
'

' Require explicitly declaring variables
Option Explicit

' quote character
Const QUOTE = """"
Dim JAVA_PATH
' Force this script to run using cscript
Sub forceCScriptExecution
    Dim Arg, Str, argPos
    If Not LCase( Right( WScript.FullName, 12 ) ) = "\cscript.exe"  Then
        For argPos = 0 to WScript.Arguments.Count - 1
            Dim key
            key = WScript.Arguments.Item(argPos)
            If key = "-j" And argPos + 1 < WScript.Arguments.Count Then
                Str = Str & " " & key
                argPos = argPos + 1
                key = WScript.Arguments.Item(argPos)
                Str = Str & " " & QUOTE  & key & QUOTE
            Else
                key = QUOTE & key & QUOTE
                Str = Str & " " & key
            End If

        Next
            CreateObject( "WScript.Shell" ).Run _
                "cscript //nologo " & _
                QUOTE & WScript.ScriptFullName & QUOTE & _
                " " & Str
            WScript.Quit
        End If

End Sub
forceCScriptExecution

Dim argPos
For argPos = 0 to WScript.Arguments.Count - 1
    Dim key, val
    key = WScript.Arguments.Item(argPos)
    val = ""
    If key = "-j" Then
        If argPos + 1 = WScript.Arguments.Count Then
             WScript.Echo "Invalid JRE home path"
             WScript.Sleep 4000
             WScript.Quit(5)
        Else
             If Len(WScript.Arguments.Item(argPos+1)) = 0 Then
                WScript.Echo "Invalid JRE home path"
                WScript.Sleep 4000
                WScript.Quit(5)
             Else
                argPos = argPos + 1
                JAVA_PATH = WScript.Arguments.Item(argPos)
             End If
        End If
    End If
Next

If Len(JAVA_PATH) > 0 Then
    Dim fso, fileFullPath
    If Right(JAVA_PATH, 1) = "\" Or Right(JAVA_PATH, 1) = "/" Then
        fileFullPath = Left(JAVA_PATH, Len(JAVA_PATH)-1)
    Else
        fileFullPath=JAVA_PATH
    End If
    fileFullPath = fileFullPath & "\bin\java.exe"
    Set fso = CreateObject("Scripting.FileSystemObject")
    If Not fso.FileExists(fileFullPath) Then
        WScript.Echo "Invalid JRE home path"
        WScript.Sleep 4000
        WScript.Quit(5)
    End If
End If


' Name of the service
Const AGENT_SVC_NAME = """Appdynamics Machine Agent"""
' Open file in overwrite mode
Const OVERWRITE = 2

Dim fsObject
Set fsObject = CreateObject("Scripting.FileSystemObject")

Dim scriptDir, serviceExe
scriptDir = fsObject.GetParentFolderName(WScript.ScriptFullName)
serviceExe = QUOTE & scriptDir & "\bin\MachineAgentService.exe" & QUOTE

' Executes a command and prints anything the process writes to stdout
' Returns Exit code of the command
Function execute(cmd)
    Dim shell, shellExec, strCommand
    Set shell = CreateObject("WScript.Shell")
    If Not (JAVA_PATH = "") Then
        strCommand = ".\config.bat" & " " & Chr(34) & JAVA_PATH & Chr(34)
        Wscript.Echo strCommand
        WScript.Sleep 100
        shell.Run strCommand, 0, True
    End If
    Set shellExec = shell.exec(cmd)
    Do Until shellExec.Status
        WScript.Sleep 100
    Loop
    Dim out
    out = shellExec.StdOut.ReadAll()
    If Not IsEmpty(out) Then
        WScript.Echo out
    End If
    execute = shellExec.ExitCode
End Function

Function installNetVizExtension()
    Dim machineAgentHome
    machineAgentHome = fsObject.GetParentFolderName(WScript.ScriptFullName)
    WScript.Echo machineAgentHome
    Dim netvizExtensionPath, netvizInstallScript, exists
    netvizExtensionPath = machineAgentHome + "\extensions\NetVizExtension\"
    netvizInstallScript = netvizExtensionPath + "install-extension.bat"
    exists = fsObject.FolderExists(netvizExtensionPath)
    If (exists) Then
        execute(netvizInstallScript)
        WScript.Echo "NetViz Agent is installed"
    End If
End Function

installNetVizExtension()

WScript.Echo "Installing AppDynamics Machine Agent into the Service Manager, configured to auto-start."
Dim exitCode
exitCode = execute(serviceExe & " /install-auto non-interactive")
If exitCode <> 0 Then
    WScript.Echo "Failed to install Machine Agent as a Service. Please run this command as an administrator"
Else
    WScript.Echo "Done."

    WScript.Echo "Configure Service to restart on failure"
    execute("SC failure " & AGENT_SVC_NAME & " reset= 432000  actions= restart/30000/restart/60000/run/60000")
    ' On 3rd failure, run a custom action. The default implementation will restart the service.
    Dim failureActionPath
    failureActionPath = QUOTE & scriptDir & "\bin\agent-failure-action.cmd" & QUOTE
    execute("SC failure " & AGENT_SVC_NAME & " command= " & failureActionPath)
    WScript.Echo "Done."

    WScript.Echo "Adding VM parameters for machine agent"
    Dim vmOptionsFile
    Set vmOptionsFile = fsObject.OpenTextFile(scriptDir & "\bin\MachineAgentService.vmoptions", OVERWRITE, True)
    ' Do not create MiniDump on crash. If the option is not supported by the JRE the exe will ignore it.
    vmOptionsFile.WriteLine("-XX:-CreateMinidumpOnCrash")
    ' Add command line parameters to the vmoptions file
    Dim arg
    Dim xmsRequired
	xmsRequired = True
    Dim xmxRequired
	xmxRequired = True
    For Each arg in WScript.Arguments
        If InStr( arg, "-Xms" ) Then
            xmsRequired = False
        End If
        If InStr( arg, "-Xmx" ) Then
            xmxRequired = False
        End If
        vmOptionsFile.WriteLine(arg)
    Next
    If xmsRequired Then
        vmOptionsFile.WriteLine("-Xms256m")
    End If
    If xmxRequired Then
        vmOptionsFile.WriteLine("-Xmx256m")
    End If
    vmOptionsFile.Close

    WScript.Echo "Starting Service"
    execute(serviceExe & " /start")
    WScript.Echo "Done."
End If

' Wait for user input
WScript.StdIn.Read(1)
