/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework.version;

import com.appdynamics.common.framework.version.Version;
import com.google.common.base.Preconditions;
import java.util.Objects;
import lombok.Generated;

public class CalendarVersion
implements Version {
    private static final String VERSION_SEPARATOR = ".";
    public static final String HOTFIX_AND_BUILD_SEPARATOR = "-";
    private static final int DEFAULT_BUILD_NUM = 0;
    private final String text;
    private final int year;
    private final int month;
    private final int iteration;
    private final int buildNumber;

    public CalendarVersion(String text) {
        int fourthComponent;
        int thirdComponent;
        this.text = Objects.requireNonNull(text);
        String[] versionComponents = text.split("\\.");
        Preconditions.checkArgument((versionComponents.length == 3 ? 1 : 0) != 0, (Object)(text + "is not a valid calendar version"));
        int firstComponent = Integer.parseInt(versionComponents[0]);
        int secondComponent = Integer.parseInt(versionComponents[1]);
        String hotfixAndBuildNum = versionComponents[2];
        String[] hotfixAndBuildNumComponents = hotfixAndBuildNum.split(HOTFIX_AND_BUILD_SEPARATOR);
        if (hotfixAndBuildNumComponents.length == 2) {
            thirdComponent = Integer.parseInt(hotfixAndBuildNumComponents[0]);
            fourthComponent = Integer.parseInt(hotfixAndBuildNumComponents[1]);
        } else {
            thirdComponent = Integer.parseInt(hotfixAndBuildNum);
            fourthComponent = 0;
        }
        Preconditions.checkArgument((firstComponent > 0 ? 1 : 0) != 0, (Object)"Year should be a non-negative integer");
        Preconditions.checkArgument((secondComponent >= 1 && secondComponent <= 12 ? 1 : 0) != 0, (Object)"Month should be in the valid range of 1 to 12, inclusive");
        Preconditions.checkArgument((thirdComponent >= 0 ? 1 : 0) != 0, (Object)"Iteration number should be non-negative");
        Preconditions.checkArgument((fourthComponent >= 0 ? 1 : 0) != 0, (Object)"Build number should be non-negative");
        this.year = firstComponent;
        this.month = secondComponent;
        this.iteration = thirdComponent;
        this.buildNumber = fourthComponent;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final String toString() {
        return this.text();
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public int getYear() {
        return this.year;
    }

    @Generated
    public int getMonth() {
        return this.month;
    }

    @Generated
    public int getIteration() {
        return this.iteration;
    }

    @Generated
    public int getBuildNumber() {
        return this.buildNumber;
    }
}

