/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.util;

import com.appdynamics.sim.agent.extensions.docker.util.UnknownValueUtil;
import lombok.Generated;

public class ExponentialMovingAverageUtil {
    private double oldValue;
    private boolean firstValue = true;
    private static final double ALPHA_NUMERATOR = 2.0;

    public double average(double alpha, double value) {
        if (this.firstValue) {
            this.oldValue = value;
            this.firstValue = false;
        } else {
            this.oldValue = UnknownValueUtil.isUnknownValue(value) ? (double)UnknownValueUtil.getUnknownValue() : (this.oldValue += alpha * (value - this.oldValue));
        }
        return this.oldValue;
    }

    public static double getAlpha(double numPeriods) {
        return 2.0 / (numPeriods + 1.0);
    }

    @Generated
    public ExponentialMovingAverageUtil() {
    }

    @Generated
    public double getOldValue() {
        return this.oldValue;
    }

    @Generated
    public boolean isFirstValue() {
        return this.firstValue;
    }

    @Generated
    public void setOldValue(double oldValue) {
        this.oldValue = oldValue;
    }

    @Generated
    public void setFirstValue(boolean firstValue) {
        this.firstValue = firstValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialMovingAverageUtil)) {
            return false;
        }
        ExponentialMovingAverageUtil other = (ExponentialMovingAverageUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getOldValue(), other.getOldValue()) != 0) {
            return false;
        }
        return this.isFirstValue() == other.isFirstValue();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExponentialMovingAverageUtil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $oldValue = Double.doubleToLongBits(this.getOldValue());
        result = result * 59 + (int)($oldValue >>> 32 ^ $oldValue);
        result = result * 59 + (this.isFirstValue() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "ExponentialMovingAverageUtil(oldValue=" + this.getOldValue() + ", firstValue=" + this.isFirstValue() + ")";
    }
}

