/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.tags;

import com.appdynamics.agent.sim.tags.GlobalTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerTagsConfigsDecider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerTagsConfigsDecider.class);
    private final GlobalTagsConfigsDecider globalTagsConfigsDecider;
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider;
    private final Provider<AgentMonitorConfig> controllerMonitoringConfigProvider;

    @Inject
    public DockerTagsConfigsDecider(GlobalTagsConfigsDecider globalTagsConfigsDecider, Provider<DockerMonitorConfig> dockerMonitorConfigProvider, Provider<AgentMonitorConfig> controllerMonitoringConfigProvider) {
        this.globalTagsConfigsDecider = globalTagsConfigsDecider;
        this.dockerMonitorConfigProvider = dockerMonitorConfigProvider;
        this.controllerMonitoringConfigProvider = controllerMonitoringConfigProvider;
    }

    public boolean isTagEnabled() {
        boolean isTagEnabled = this.globalTagsConfigsDecider.isTagEnabled();
        boolean isControllerDockerTagEnabled = ((AgentMonitorConfig)this.controllerMonitoringConfigProvider.get()).isDockerTagsEnabled();
        boolean isAgentDockerTagEnabled = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getContainerMonitoringConfig().getDockerTagsEnabled();
        log.trace("TagEnabled: {}, Controller DockerTagsEnabled: {}, Agent DockerTagsEnabled: {}", new Object[]{isTagEnabled, isControllerDockerTagEnabled, isAgentDockerTagEnabled});
        return isTagEnabled && isControllerDockerTagEnabled && isAgentDockerTagEnabled;
    }
}

