/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.model.filter;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerProcessComponent;
import com.appdynamics.sim.agent.extensions.docker.model.filter.IComponentRankingMethod;
import com.appdynamics.sim.agent.extensions.docker.util.Pair;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerProcessRankingMethod<RAWDATA>
implements IComponentRankingMethod<ContainerProcessComponent<RAWDATA>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerProcessRankingMethod.class);
    private static final Ordering<ContainerProcessComponent.SimProcessObservationDtoMetrics> CPU_ORDERING = Ordering.compound(Arrays.asList(new Ordering[]{new DescCpuOrdering(), new ClassIdOrdering()}));
    private static final Ordering<ContainerProcessComponent.SimProcessObservationDtoMetrics> MEM_ORDERING = Ordering.compound(Arrays.asList(new Ordering[]{new DescMemOrdering(), new ClassIdOrdering()}));
    private static final Ordering<ProcessScore> PROCESS_SCORE_ORDERING = Ordering.compound(Arrays.asList(new Ordering[]{new DescendingScoreOrdering(), new ProcessClassIdOrdering()}));
    private static Pattern criticalProcessesSelectorPattern = Pattern.compile("");

    @Override
    public List<SimProcessObservationDto> rank(ContainerProcessComponent<RAWDATA> component) {
        return this.rankByCustomProcessScores(component);
    }

    @VisibleForTesting
    List<SimProcessObservationDto> rankByHighestUsage(@NonNull ContainerProcessComponent<RAWDATA> component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        ImmutableList cpuSortedClasses = CPU_ORDERING.immutableSortedCopy(new ArrayList<ContainerProcessComponent.SimProcessObservationDtoMetrics>(component.getPidToSimProcessObservationDtoMetricsMap().values()));
        ImmutableList memSortedClasses = MEM_ORDERING.immutableSortedCopy(new ArrayList<ContainerProcessComponent.SimProcessObservationDtoMetrics>(component.getPidToSimProcessObservationDtoMetricsMap().values()));
        UnmodifiableIterator oneIter = cpuSortedClasses.iterator();
        UnmodifiableIterator otherIter = memSortedClasses.iterator();
        ArrayList<SimProcessObservationDto> rankedContainerProcessObservations = new ArrayList<SimProcessObservationDto>(component.getPidToSimProcessObservationDtoMap().size());
        while (oneIter.hasNext() || otherIter.hasNext()) {
            if (oneIter.hasNext()) {
                rankedContainerProcessObservations.add(component.getPidToSimProcessObservationDtoMap().get(((ContainerProcessComponent.SimProcessObservationDtoMetrics)((Object)oneIter.next())).getProcessId()));
            }
            if (!otherIter.hasNext()) continue;
            UnmodifiableIterator tempIter = oneIter;
            oneIter = otherIter;
            otherIter = tempIter;
        }
        return rankedContainerProcessObservations;
    }

    @VisibleForTesting
    List<SimProcessObservationDto> rankByCustomProcessScores(@NonNull ContainerProcessComponent<RAWDATA> component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        DockerProcessRankingMethod.setCriticalProcessesSelectorPattern(component.getCriticalProcessSelectorPattern());
        List<ProcessScore> processScores = this.createProcessRankingScores(component);
        ArrayList<SimProcessObservationDto> rankedContainerProcessObservations = new ArrayList<SimProcessObservationDto>(processScores.size());
        for (ProcessScore ps : processScores) {
            rankedContainerProcessObservations.add(component.getPidToSimProcessObservationDtoMap().get(ps.getPid().get()));
        }
        return rankedContainerProcessObservations;
    }

    private List<ProcessScore> createProcessRankingScores(ContainerProcessComponent<RAWDATA> component) {
        ArrayList<ProcessScore> processScores = new ArrayList<ProcessScore>();
        Map<RawDataLong, Pair<RawDataLong, Double>> cpuMetrics = component.getProcessPidToCpuMetricsMap();
        Map<RawDataLong, Pair<RawDataLong, Double>> memoryMetrics = component.getProcessPidToMemoryMetricsMap();
        Map<RawDataLong, String> commandLineMap = component.getProcessPidToCommandLineMap();
        Set<RawDataLong> pids = cpuMetrics.keySet();
        for (RawDataLong pid : pids) {
            Pair<RawDataLong, Double> cpuData = cpuMetrics.get(pid);
            Pair<RawDataLong, Double> memoryData = memoryMetrics.get(pid);
            String commandLine = commandLineMap.get(pid);
            double score = DockerProcessRankingMethod.calculateScore(cpuData, memoryData, commandLine, pid);
            ProcessScore processScore = new ProcessScore(pid, cpuData, memoryData, commandLine, component.getPidToSimProcessObservationDtoMap().get(pid.get()).getClassId(), score);
            processScores.add(processScore);
        }
        Collections.sort(processScores, PROCESS_SCORE_ORDERING);
        return processScores;
    }

    private static double calculateScore(Pair<RawDataLong, Double> cpuData, Pair<RawDataLong, Double> memoryData, String commandLine, RawDataLong pid) {
        double cpuUsage = cpuData.getSecond();
        double memoryUsage = memoryData.getSecond();
        boolean isCriticalProcess = DockerProcessRankingMethod.isCriticalProcess(commandLine, pid);
        double cpuWeight = 0.5;
        double memoryWeight = 0.5;
        double criticalProcessWeight = 40.0;
        double score = cpuUsage * cpuWeight + memoryUsage * memoryWeight;
        if (isCriticalProcess) {
            score += criticalProcessWeight;
        }
        return score;
    }

    private static boolean isCriticalProcess(String commandLine, RawDataLong pid) {
        if (criticalProcessesSelectorPattern == null) {
            return false;
        }
        Matcher matcher = criticalProcessesSelectorPattern.matcher(commandLine);
        boolean isCritical = matcher.find();
        if (isCritical) {
            log.debug("Process with pid: {} and commandLine: {} marked as a critical process", (Object)pid.get(), (Object)commandLine);
        }
        return isCritical;
    }

    @VisibleForTesting
    private static void setCriticalProcessesSelectorPattern(Pattern criticalProcessesPattern) {
        criticalProcessesSelectorPattern = criticalProcessesPattern;
    }

    static class ProcessScore
    implements Comparable<ProcessScore> {
        RawDataLong pid;
        Pair<RawDataLong, Double> memoryData;
        Pair<RawDataLong, Double> cpuData;
        String commandLine;
        String classId;
        double score;

        @Override
        public int compareTo(@NotNull ProcessScore other) {
            return PROCESS_SCORE_ORDERING.compare((Object)this, (Object)other);
        }

        @Generated
        ProcessScore(RawDataLong pid, Pair<RawDataLong, Double> memoryData, Pair<RawDataLong, Double> cpuData, String commandLine, String classId, double score) {
            this.pid = pid;
            this.memoryData = memoryData;
            this.cpuData = cpuData;
            this.commandLine = commandLine;
            this.classId = classId;
            this.score = score;
        }

        @Generated
        public static ProcessScoreBuilder builder() {
            return new ProcessScoreBuilder();
        }

        @Generated
        public RawDataLong getPid() {
            return this.pid;
        }

        @Generated
        public String getClassId() {
            return this.classId;
        }

        @Generated
        public double getScore() {
            return this.score;
        }

        @Generated
        public static class ProcessScoreBuilder {
            @Generated
            private RawDataLong pid;
            @Generated
            private Pair<RawDataLong, Double> memoryData;
            @Generated
            private Pair<RawDataLong, Double> cpuData;
            @Generated
            private String commandLine;
            @Generated
            private String classId;
            @Generated
            private double score;

            @Generated
            ProcessScoreBuilder() {
            }

            @Generated
            public ProcessScoreBuilder pid(RawDataLong pid) {
                this.pid = pid;
                return this;
            }

            @Generated
            public ProcessScoreBuilder memoryData(Pair<RawDataLong, Double> memoryData) {
                this.memoryData = memoryData;
                return this;
            }

            @Generated
            public ProcessScoreBuilder cpuData(Pair<RawDataLong, Double> cpuData) {
                this.cpuData = cpuData;
                return this;
            }

            @Generated
            public ProcessScoreBuilder commandLine(String commandLine) {
                this.commandLine = commandLine;
                return this;
            }

            @Generated
            public ProcessScoreBuilder classId(String classId) {
                this.classId = classId;
                return this;
            }

            @Generated
            public ProcessScoreBuilder score(double score) {
                this.score = score;
                return this;
            }

            @Generated
            public ProcessScore build() {
                return new ProcessScore(this.pid, this.memoryData, this.cpuData, this.commandLine, this.classId, this.score);
            }

            @Generated
            public String toString() {
                return "DockerProcessRankingMethod.ProcessScore.ProcessScoreBuilder(pid=" + String.valueOf(this.pid) + ", memoryData=" + String.valueOf(this.memoryData) + ", cpuData=" + String.valueOf(this.cpuData) + ", commandLine=" + this.commandLine + ", classId=" + this.classId + ", score=" + this.score + ")";
            }
        }
    }

    @VisibleForTesting
    static class DescCpuOrdering
    extends Ordering<ContainerProcessComponent.SimProcessObservationDtoMetrics> {
        DescCpuOrdering() {
        }

        public int compare(ContainerProcessComponent.SimProcessObservationDtoMetrics o1, ContainerProcessComponent.SimProcessObservationDtoMetrics o2) {
            return Double.compare(o2.getCpuUtilizationMovingAverage().getOldValue(), o1.getCpuUtilizationMovingAverage().getOldValue());
        }
    }

    @VisibleForTesting
    static class ClassIdOrdering
    extends Ordering<ContainerProcessComponent.SimProcessObservationDtoMetrics> {
        private final Ordering<String> stringOrdering = Ordering.natural();

        ClassIdOrdering() {
        }

        public int compare(ContainerProcessComponent.SimProcessObservationDtoMetrics o1, ContainerProcessComponent.SimProcessObservationDtoMetrics o2) {
            return this.stringOrdering.compare((Object)o1.getClassId(), (Object)o2.getClassId());
        }
    }

    @VisibleForTesting
    static class DescMemOrdering
    extends Ordering<ContainerProcessComponent.SimProcessObservationDtoMetrics> {
        DescMemOrdering() {
        }

        public int compare(ContainerProcessComponent.SimProcessObservationDtoMetrics o1, ContainerProcessComponent.SimProcessObservationDtoMetrics o2) {
            return Double.compare(o2.getMemKbMovingAverage().getOldValue(), o1.getMemKbMovingAverage().getOldValue());
        }
    }

    @VisibleForTesting
    static class DescendingScoreOrdering
    extends Ordering<ProcessScore> {
        DescendingScoreOrdering() {
        }

        public int compare(ProcessScore o1, ProcessScore o2) {
            return Double.compare(o2.getScore(), o1.getScore());
        }
    }

    @VisibleForTesting
    static class ProcessClassIdOrdering
    extends Ordering<ProcessScore> {
        private final Ordering<String> stringOrdering = Ordering.natural();

        ProcessClassIdOrdering() {
        }

        public int compare(ProcessScore o1, ProcessScore o2) {
            return this.stringOrdering.compare((Object)o1.getClassId(), (Object)o2.getClassId());
        }
    }
}

