/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.model;

import com.appdynamics.agent.sim.docker.model.ContainerProcess;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricHoleHandlingType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessProperties;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerComponent;
import com.appdynamics.sim.agent.extensions.docker.util.ExponentialMovingAverageUtil;
import com.appdynamics.sim.agent.extensions.docker.util.NixRawDataProcessClassSummingCalculator;
import com.appdynamics.sim.agent.extensions.docker.util.Pair;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import com.singularity.ee.controller.api.constants.HardwarePerformanceMetricsTemplates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerProcessComponent<RAWDATA>
implements ContainerComponent<RAWDATA> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerProcessComponent.class);
    private static final long DEFAULT_LOGICAL_CORES = 1L;
    private final MetricsService metricsService;
    private final DockerProcessProperties processProperties;
    protected final Provider<DockerMonitorConfig> dockerMonitorConfigProvider;
    protected final RawDataFactory factory;
    private NixRawDataProcessClassSummingCalculator majorFaultsRate;
    private NixRawDataProcessClassSummingCalculator minorFaultsRate;

    protected ContainerProcessComponent(MetricsService metricsService, DockerProcessProperties processProperties, Provider<DockerMonitorConfig> dockerMonitorConfigProvider, RawDataFactory factory) {
        this.metricsService = metricsService;
        this.processProperties = processProperties;
        this.dockerMonitorConfigProvider = dockerMonitorConfigProvider;
        this.factory = factory;
        this.majorFaultsRate = new NixRawDataProcessClassSummingCalculator(factory, NixRawDataProcessClassSummingCalculator.RATE_CALC);
        this.minorFaultsRate = new NixRawDataProcessClassSummingCalculator(factory, NixRawDataProcessClassSummingCalculator.RATE_CALC);
    }

    @Override
    public void report() {
        if (this.getObservationsToReport() != null) {
            this.reportClassLevelMetrics();
            this.reportProcessLevelMetrics();
            this.processProperties.addProcessObservations(this.getObservationsToReport());
        }
    }

    private void reportClassLevelMetrics() {
        log.debug("Reporting process class level metrics for container {}", (Object)this.getContainerHostId());
        HashMap<String, RawDataLong> classIdToMemoryUsedPctMap = new HashMap<String, RawDataLong>();
        HashMap<String, RawDataLong> classIdToThreadCountMap = new HashMap<String, RawDataLong>();
        HashMap<String, RawDataLong> classIdToVirtualMemoryKbMap = new HashMap<String, RawDataLong>();
        HashMap<String, RawDataLong> classIdToMemoryUsedKbMap = new HashMap<String, RawDataLong>();
        HashMap<String, RawDataLong> classIdToCpuUsedPctMap = new HashMap<String, RawDataLong>();
        HashMap<String, RawDataLong> classIdToMajorFaultsMap = new HashMap<String, RawDataLong>();
        HashMap<String, RawDataLong> classIdToMinorFaultsMap = new HashMap<String, RawDataLong>();
        HashMap<String, List> classIdToObservationMap = new HashMap<String, List>();
        for (SimProcessObservationDto simProcessObservationDto : this.getObservationsToReport()) {
            classIdToObservationMap.putIfAbsent(simProcessObservationDto.getClassId(), new ArrayList());
            List processesList = (List)classIdToObservationMap.get(simProcessObservationDto.getClassId());
            processesList.add(simProcessObservationDto);
            classIdToObservationMap.put(simProcessObservationDto.getClassId(), processesList);
        }
        for (Map.Entry entry : classIdToObservationMap.entrySet()) {
            List observationDtosForClassId = (List)entry.getValue();
            RawDataLong memoryUsedKb = RawDataConstants.ZERO_LONG;
            RawDataLong numThreads = RawDataConstants.ZERO_LONG;
            RawDataLong virtualMemoryKb = RawDataConstants.ZERO_LONG;
            ImmutableSet.Builder reportedProcessIdSetBuilder = new ImmutableSet.Builder();
            ImmutableMap.Builder pidToMajorFaultMapBuilder = new ImmutableMap.Builder();
            ImmutableMap.Builder pidToMinorFaultMapBuilder = new ImmutableMap.Builder();
            double memoryUsedPercentDbl = 0.0;
            double cpuUsedPercentDbl = 0.0;
            for (SimProcessObservationDto observationDto : observationDtosForClassId) {
                memoryUsedKb = memoryUsedKb.add(this.factory.createLong(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getMemoryUsedKb()));
                numThreads = numThreads.add(this.factory.createLong(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getThreadCount()));
                virtualMemoryKb = virtualMemoryKb.add(this.factory.createLong(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getVirtualMemSizeKb()));
                try {
                    double memory = Double.parseDouble(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getMemoryPercent());
                    memoryUsedPercentDbl += memory;
                    double cpu = Double.parseDouble(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getCpuPercent());
                    cpuUsedPercentDbl += cpu;
                }
                catch (IllegalStateException | NumberFormatException memory) {
                    // empty catch block
                }
                reportedProcessIdSetBuilder.add((Object)this.factory.createLong(Long.valueOf(observationDto.getProcessId())));
                pidToMajorFaultMapBuilder.put((Object)this.factory.createLong(Long.valueOf(observationDto.getProcessId())), (Object)this.factory.createLong(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getMajorFaults()));
                pidToMinorFaultMapBuilder.put((Object)this.factory.createLong(Long.valueOf(observationDto.getProcessId())), (Object)this.factory.createLong(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getMinorFaults()));
            }
            classIdToMemoryUsedKbMap.put((String)entry.getKey(), memoryUsedKb);
            classIdToThreadCountMap.put((String)entry.getKey(), numThreads);
            classIdToVirtualMemoryKbMap.put((String)entry.getKey(), virtualMemoryKb);
            RawDataLong memoryUsedPercent = this.factory.createLong(Long.valueOf(Math.round(memoryUsedPercentDbl)));
            classIdToMemoryUsedPctMap.put((String)entry.getKey(), memoryUsedPercent);
            RawDataLong cpuUsedPercent = this.factory.createLong(Long.valueOf(Math.round(cpuUsedPercentDbl)));
            classIdToCpuUsedPctMap.put((String)entry.getKey(), cpuUsedPercent);
            ImmutableSet reportedProcessIdSet = reportedProcessIdSetBuilder.build();
            this.majorFaultsRate.calculate((ImmutableMap<RawDataLong, RawDataLong>)pidToMajorFaultMapBuilder.build(), this.factory.createLong(Long.valueOf(System.currentTimeMillis())), (Set<RawDataLong>)reportedProcessIdSet);
            classIdToMajorFaultsMap.put((String)entry.getKey(), this.majorFaultsRate.getLastCookedResult());
            this.minorFaultsRate.calculate((ImmutableMap<RawDataLong, RawDataLong>)pidToMinorFaultMapBuilder.build(), this.factory.createLong(Long.valueOf(System.currentTimeMillis())), (Set<RawDataLong>)reportedProcessIdSet);
            classIdToMinorFaultsMap.put((String)entry.getKey(), this.minorFaultsRate.getLastCookedResult());
        }
        for (SimProcessObservationDto simProcessObservationDto : this.getObservationsToReport()) {
            this.reportMetric(this.metricsService, simProcessObservationDto.getClassId(), "Hardware Resources|Process|{0}|Memory|Used (%)", ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)classIdToMemoryUsedPctMap.get(simProcessObservationDto.getClassId()));
            this.reportMetric(this.metricsService, simProcessObservationDto.getClassId(), "Hardware Resources|Process|{0}|Memory|Used (KB)", ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)classIdToMemoryUsedKbMap.get(simProcessObservationDto.getClassId()));
            this.reportMetric(this.metricsService, simProcessObservationDto.getClassId(), "Hardware Resources|Process|{0}|Threads|Count", ExtensionMetricAggregatorType.AVERAGE, ExtensionMetricHoleHandlingType.RATE_COUNTER, (RawDataLong)classIdToThreadCountMap.get(simProcessObservationDto.getClassId()));
            this.reportMetric(this.metricsService, simProcessObservationDto.getClassId(), "Hardware Resources|Process|{0}|Faults|Major Faults/sec", ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)classIdToMajorFaultsMap.get(simProcessObservationDto.getClassId()));
            this.reportMetric(this.metricsService, simProcessObservationDto.getClassId(), "Hardware Resources|Process|{0}|Faults|Minor Faults/sec", ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)classIdToMinorFaultsMap.get(simProcessObservationDto.getClassId()));
            this.reportMetric(this.metricsService, simProcessObservationDto.getClassId(), "Hardware Resources|Process|{0}|CPU|Used (%)", ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)classIdToCpuUsedPctMap.get(simProcessObservationDto.getClassId()));
            this.reportMetric(this.metricsService, simProcessObservationDto.getClassId(), "Hardware Resources|Process|{0}|Memory|Virtual (KB)", ExtensionMetricAggregatorType.AVERAGE, (RawDataLong)classIdToVirtualMemoryKbMap.get(simProcessObservationDto.getClassId()));
            this.reportMetric(this.metricsService, simProcessObservationDto.getClassId(), "Hardware Resources|Process|{0}|Count", ExtensionMetricAggregatorType.AVERAGE, ExtensionMetricHoleHandlingType.RATE_COUNTER, this.factory.createLong(Long.valueOf(this.getObservationsToReport().size())));
        }
    }

    private void reportProcessLevelMetrics() {
        log.debug("Reporting process level metrics for container {}", (Object)this.getContainerHostId());
        for (SimProcessObservationDto observationDto : this.getObservationsToReport()) {
            this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Process|{0}|{1}|CPU|Used (%)", (String)observationDto.getClassId(), (String)String.valueOf(observationDto.getProcessId())), ExtensionMetricAggregatorType.AVERAGE, this.factory.createLong(Long.valueOf((long)Double.parseDouble(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getCpuPercent()))));
            this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Process|{0}|{1}|Memory|Used (%)", (String)observationDto.getClassId(), (String)String.valueOf(observationDto.getProcessId())), ExtensionMetricAggregatorType.AVERAGE, this.factory.createLong(Long.valueOf((long)Double.parseDouble(this.getPidToContainerProcessMap().get(observationDto.getProcessId()).getMemoryPercent()))));
            this.metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Process|{0}|{1}|State", (String)observationDto.getClassId(), (String)String.valueOf(observationDto.getProcessId())), ExtensionMetricAggregatorType.AVERAGE, this.factory.createLong(Long.valueOf(observationDto.getState().ordinal())));
        }
    }

    private void reportMetric(MetricsService metricsService, String classId, String metricNameTemplate, ExtensionMetricAggregatorType aggregatorType, RawDataLong value) {
        metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)metricNameTemplate, (String)classId), aggregatorType, value);
    }

    private void reportMetric(MetricsService metricsService, String classId, String metricNameTemplate, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricHoleHandlingType holeHandlingType, RawDataLong value) {
        metricsService.reportMetric(HardwarePerformanceMetricsTemplates.format((String)metricNameTemplate, (String)classId), aggregatorType, holeHandlingType, value);
    }

    @VisibleForTesting
    public long calculateHostLogicalCores(Map<String, String> hostProperties) {
        long returnValue = 1L;
        String hostLogicalCores = hostProperties.get("Total|CPU|Logical Processor Count");
        if (hostLogicalCores != null) {
            try {
                returnValue = Long.valueOf(hostLogicalCores);
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to convert the host's logical core, raw data: {}", (Object)hostLogicalCores);
            }
        }
        return returnValue;
    }

    public Pattern getCriticalProcessSelectorPattern() {
        return ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getCriticalProcessSelectorPattern();
    }

    public abstract String getContainerHostId();

    public abstract List<SimProcessObservationDto> getObservationsToReport();

    public abstract Map<Long, SimProcessObservationDto> getPidToSimProcessObservationDtoMap();

    public abstract Map<Long, ContainerProcess> getPidToContainerProcessMap();

    public abstract RawDataLong getHostCpuLogicalCores();

    public abstract Map<RawDataLong, Pair<RawDataLong, Double>> getProcessPidToCpuMetricsMap();

    public abstract Map<RawDataLong, Pair<RawDataLong, Double>> getProcessPidToMemoryMetricsMap();

    public abstract Map<RawDataLong, String> getProcessPidToCommandLineMap();

    public abstract Map<RawDataLong, SimProcessObservationDtoMetrics> getPidToSimProcessObservationDtoMetricsMap();

    public static class SimProcessObservationDtoMetrics
    extends SimProcessObservationDto {
        private ExponentialMovingAverageUtil cpuUtilizationMovingAverage;
        private ExponentialMovingAverageUtil memKbMovingAverage;

        public SimProcessObservationDtoMetrics(SimProcessObservationDto dto) {
            super(dto.getLiveTime(), dto.getClassId(), dto.getProcessClass(), dto.getName(), dto.getProcessId(), dto.getParentProcessId(), dto.getCommandLine(), dto.getEffectiveUser(), dto.getState(), dto.getProperties());
            this.setCpuUtilizationMovingAverage(new ExponentialMovingAverageUtil());
            this.setMemKbMovingAverage(new ExponentialMovingAverageUtil());
        }

        @Generated
        public ExponentialMovingAverageUtil getCpuUtilizationMovingAverage() {
            return this.cpuUtilizationMovingAverage;
        }

        @Generated
        public void setCpuUtilizationMovingAverage(ExponentialMovingAverageUtil cpuUtilizationMovingAverage) {
            this.cpuUtilizationMovingAverage = cpuUtilizationMovingAverage;
        }

        @Generated
        public ExponentialMovingAverageUtil getMemKbMovingAverage() {
            return this.memKbMovingAverage;
        }

        @Generated
        public void setMemKbMovingAverage(ExponentialMovingAverageUtil memKbMovingAverage) {
            this.memKbMovingAverage = memKbMovingAverage;
        }
    }
}

