/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.ReportingUtil;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerComponent;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerNetwork;
import com.appdynamics.sim.common.biz.shared.machines.SimMachineProperties;
import com.google.inject.Provider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerNetworks<RAWDATA>
implements ContainerComponent<RAWDATA> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerNetworks.class);
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider = new Provider<DockerMonitorConfig>(){

        public DockerMonitorConfig get() {
            return new DockerMonitorConfig();
        }
    };
    private static final long DEFAULT_METRIC_VALUE = 0L;
    protected final Map<String, ContainerNetwork<RAWDATA>> components;
    protected final MetricsService metricsService;
    protected final MachineProperties machineProperties;
    private boolean firstTime;

    protected ContainerNetworks(MetricsService metricsService, MachineProperties machineProperties) {
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
        this.components = new LinkedHashMap<String, ContainerNetwork<RAWDATA>>();
        this.firstTime = true;
    }

    @Override
    public void report() {
        for (ContainerNetwork<RAWDATA> component : this.components.values()) {
            Pattern blacklistRegexPattern = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getNetworkMonitorConfig().getNetworkBlacklistPattern();
            if (!blacklistRegexPattern.matcher(component.networkName).matches()) {
                component.report();
                continue;
            }
            log.debug("Network name " + component.networkName + " matches with blacklistRegex, not reporting this network!");
        }
        long aggregatedIncomingKb = 0L;
        long aggregatedOutgoingKb = 0L;
        long aggregatedIncomingKbPerSec = 0L;
        long aggregatedOutgoingKbPerSec = 0L;
        long aggregatedIncomingPackets = 0L;
        long aggregatedOutgoingPackets = 0L;
        long aggregatedIncomingErrors = 0L;
        long aggregatedOutgoingErrors = 0L;
        long aggregatedIncomingPacketsDropped = 0L;
        long aggregatedOutgoingPacketsDropped = 0L;
        if (!this.components.isEmpty()) {
            for (ContainerNetwork<RAWDATA> network : this.components.values()) {
                aggregatedIncomingKb += ((Long)network.getIncomingKb().or((Object)0L)).longValue();
                aggregatedOutgoingKb += ((Long)network.getOutgoingKb().or((Object)0L)).longValue();
                aggregatedIncomingKbPerSec += ((Long)network.getIncomingKbPerSec().or((Object)0L)).longValue();
                aggregatedOutgoingKbPerSec += ((Long)network.getOutgoingKbPerSec().or((Object)0L)).longValue();
                aggregatedIncomingPackets += ((Long)network.getIncomingPackets().or((Object)0L)).longValue();
                aggregatedOutgoingPackets += ((Long)network.getOutgoingPackets().or((Object)0L)).longValue();
                aggregatedIncomingErrors += ((Long)network.getIncomingErrors().or((Object)0L)).longValue();
                aggregatedOutgoingErrors += ((Long)network.getOutgoingErrors().or((Object)0L)).longValue();
                aggregatedIncomingPacketsDropped += ((Long)network.getIncomingPacketsDropped().or((Object)0L)).longValue();
                aggregatedOutgoingPacketsDropped += ((Long)network.getOutgoingPacketsDropped().or((Object)0L)).longValue();
            }
        }
        if (!this.firstTime) {
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming KB", (long)aggregatedIncomingKb);
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing KB", (long)aggregatedOutgoingKb);
            ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming KB/sec", (long)aggregatedIncomingKbPerSec);
            ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing KB/sec", (long)aggregatedOutgoingKbPerSec);
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming packets", (long)aggregatedIncomingPackets);
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing packets", (long)aggregatedOutgoingPackets);
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming Errors", (long)aggregatedIncomingErrors);
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing Errors", (long)aggregatedOutgoingErrors);
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming packets dropped", (long)aggregatedIncomingPacketsDropped);
            ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing packets dropped", (long)aggregatedOutgoingPacketsDropped);
        }
        this.firstTime = false;
        for (String interfaceName : this.components.keySet()) {
            this.machineProperties.updateProperty(SimMachineProperties.format((String)"Network Interface|{0}|Name", (String)interfaceName), interfaceName);
        }
    }
}

