/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.model;

import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.ReportingUtil;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerComponent;
import com.appdynamics.sim.common.rest.constants.SimMetricsConstants;
import com.google.common.base.Optional;
import com.singularity.ee.controller.api.constants.HardwarePerformanceMetricsTemplates;
import lombok.Generated;
import lombok.NonNull;

public abstract class ContainerNetwork<RAWDATA>
implements ContainerComponent<RAWDATA> {
    private final MetricsService metricsService;
    private boolean firstTime = true;
    protected final String networkName;
    private String metricNameIncomingKb;
    private String metricNameOutgoingKb;
    private String metricNameIncomingKbPerSec;
    private String metricNameOutgoingKbPerSec;
    private String metricNameIncomingErrors;
    private String metricNameOutgoingErrors;
    private String metricNameIncomingPackets;
    private String metricNameOutgoingPackets;
    private String metricNameIncomingPacketsDropped;
    private String metricNameOutgoingPacketsDropped;

    protected ContainerNetwork(@NonNull String networkName, MetricsService metricsService) {
        if (networkName == null) {
            throw new NullPointerException("networkName is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.networkName = networkName;
        this.metricNameIncomingKb = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Incoming KB", (String)networkName);
        this.metricNameOutgoingKb = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing KB", (String)networkName);
        this.metricNameIncomingKbPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Incoming KB/sec", (String)networkName);
        this.metricNameOutgoingKbPerSec = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing KB/sec", (String)networkName);
        this.metricNameIncomingErrors = SimMetricsConstants.format((String)"Hardware Resources|Network|{0}|Incoming Errors", (Object)networkName);
        this.metricNameOutgoingErrors = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing Errors", (String)networkName);
        this.metricNameIncomingPackets = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Incoming packets", (String)networkName);
        this.metricNameOutgoingPackets = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Network|{0}|Outgoing packets", (String)networkName);
        this.metricNameIncomingPacketsDropped = SimMetricsConstants.format((String)"Hardware Resources|Network|{0}|Incoming packets dropped", (Object)networkName);
        this.metricNameOutgoingPacketsDropped = SimMetricsConstants.format((String)"Hardware Resources|Network|{0}|Outgoing packets dropped", (Object)networkName);
    }

    @Override
    public void report() {
        if (!this.firstTime) {
            ReportingUtil.reportPerMinuteOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingKb, this.getIncomingKb());
            ReportingUtil.reportPerMinuteOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingKb, this.getOutgoingKb());
            ReportingUtil.reportPerSecondOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingKbPerSec, this.getIncomingKbPerSec());
            ReportingUtil.reportPerSecondOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingKbPerSec, this.getOutgoingKbPerSec());
            ReportingUtil.reportPerMinuteOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingErrors, this.getIncomingErrors());
            ReportingUtil.reportPerMinuteOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingErrors, this.getOutgoingErrors());
            ReportingUtil.reportPerMinuteOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingPackets, this.getIncomingPackets());
            ReportingUtil.reportPerMinuteOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingPackets, this.getOutgoingPackets());
            ReportingUtil.reportPerMinuteOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameIncomingPacketsDropped, this.getIncomingPacketsDropped());
            ReportingUtil.reportPerMinuteOptionalMetricSample((MetricsService)this.metricsService, (String)this.metricNameOutgoingPacketsDropped, this.getOutgoingPacketsDropped());
        }
        this.firstTime = false;
    }

    protected abstract Optional<Long> getIncomingKb();

    protected abstract Optional<Long> getOutgoingKb();

    protected abstract Optional<Long> getIncomingKbPerSec();

    protected abstract Optional<Long> getOutgoingKbPerSec();

    protected abstract Optional<Long> getIncomingPackets();

    protected abstract Optional<Long> getOutgoingPackets();

    protected abstract Optional<Long> getIncomingErrors();

    protected abstract Optional<Long> getOutgoingErrors();

    protected abstract Optional<Long> getIncomingPacketsDropped();

    protected abstract Optional<Long> getOutgoingPacketsDropped();

    @Generated
    public String getNetworkName() {
        return this.networkName;
    }
}

