/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.ReportingUtil;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerComponent;
import com.google.common.base.Optional;

public abstract class ContainerMemory<RAWDATA>
implements ContainerComponent<RAWDATA> {
    private final MetricsService metricsService;
    private final MachineProperties machineProperties;
    private boolean firstTime = true;

    protected ContainerMemory(MetricsService metricsService, MachineProperties machineProperties) {
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
    }

    @Override
    public void report() {
        if (!this.firstTime) {
            Optional<Long> pageMaFault;
            Optional<Long> cache;
            Optional<Long> rss;
            Optional<Long> failedCount;
            Optional<Long> memoryUsedPercentage;
            Optional<Long> memoryUsedMB = this.getMemoryUsedMB();
            if (memoryUsedMB.isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Memory|Used (MB)", ExtensionMetricAggregatorType.AVERAGE, ((Long)memoryUsedMB.get()).longValue());
            }
            if ((memoryUsedPercentage = this.getMemoryUsedPercentage()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Memory|Used %", ExtensionMetricAggregatorType.AVERAGE, ((Long)memoryUsedPercentage.get()).longValue());
            }
            if ((failedCount = this.getFailedCount()).isPresent()) {
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Memory|Failed Count", (long)((Long)failedCount.get()));
            }
            if ((rss = this.getRssSize()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Memory|Resident Set Size (MB)", ExtensionMetricAggregatorType.AVERAGE, ((Long)rss.get()).longValue());
            }
            if ((cache = this.getCacheSize()).isPresent()) {
                this.metricsService.reportMetric("Hardware Resources|Memory|Cache Size (MB)", ExtensionMetricAggregatorType.AVERAGE, ((Long)cache.get()).longValue());
            }
            if ((pageMaFault = this.getPageMaFaultCount()).isPresent()) {
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Memory|Page Major Fault Count", (long)((Long)pageMaFault.get()));
            }
        }
        this.firstTime = false;
        Optional<Long> memoryLimit = this.getMemoryLimit();
        if (memoryLimit.isPresent()) {
            this.machineProperties.updateProperty("Container|Memory|Limit", String.valueOf(memoryLimit.get()));
        }
    }

    protected abstract Optional<Long> getPageMaFaultCount();

    protected abstract Optional<Long> getCacheSize();

    protected abstract Optional<Long> getRssSize();

    protected abstract Optional<Long> getFailedCount();

    protected abstract Optional<Long> getMemoryUsedMB();

    protected abstract Optional<Long> getMemoryUsedPercentage();

    protected abstract Optional<Long> getMemoryLimit();

    protected Optional<Long> calculateEffectiveMemoryUsed(Optional<Long> memoryUsageInBytes, Optional<Long> cacheInBytes) {
        if (memoryUsageInBytes.isPresent()) {
            return Optional.of((Object)((Long)memoryUsageInBytes.get() - (Long)cacheInBytes.or((Object)0L)));
        }
        return Optional.absent();
    }

    protected Optional<Long> calculateEffectiveMemoryUsedPercentage(Optional<Long> memoryUsageInBytes, Optional<Long> cacheInBytes, Optional<Long> memoryLimitInBytes) {
        Optional<Long> effectiveMemoryUsage = this.calculateEffectiveMemoryUsed(memoryUsageInBytes, cacheInBytes);
        if (effectiveMemoryUsage.isPresent() && memoryLimitInBytes.isPresent()) {
            double effectiveMemoryUsedPercent = 0.0;
            if ((double)((Long)memoryLimitInBytes.get()).longValue() > 0.0) {
                effectiveMemoryUsedPercent = (double)((Long)effectiveMemoryUsage.get()).longValue() / (double)((Long)memoryLimitInBytes.get()).longValue() * 100.0;
            }
            return Optional.of((Object)Math.round(effectiveMemoryUsedPercent));
        }
        return Optional.absent();
    }
}

