/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.docker.model.DockerApiContainerMetricsRawData;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessProperties;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model.DockerApiContainerCpu;
import com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model.DockerApiContainerDisk;
import com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model.DockerApiContainerMemory;
import com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model.DockerApiContainerNetworks;
import com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model.DockerApiContainerProcess;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerComponent;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerMetrics;
import com.appdynamics.sim.agent.extensions.docker.model.filter.DockerProcessRankingMethod;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerApiContainerMetrics
implements ContainerMetrics<DockerApiContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerApiContainerMetrics.class);
    private final EnumMap<ContainerComponentName, ContainerComponent<DockerApiContainerMetricsRawData>> containerComponentMap;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    public DockerApiContainerMetrics(@Assisted @NonNull MetricsService metricsService, @Assisted @NonNull MachineProperties machineProperties, Provider<DockerMonitorConfig> dockerMonitorConfig, @NonNull DockerProcessProperties processProperties, @NonNull RawDataFactory factory, SimAgentRepetitiveLogger repetitiveLogger, BootstrapConfiguration bootstrapConfiguration) {
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.repetitiveLogger = repetitiveLogger;
        this.bootstrapConfiguration = bootstrapConfiguration;
        DockerApiContainerNetworks dockerApiContainerNetworks = new DockerApiContainerNetworks(metricsService, machineProperties);
        DockerApiContainerCpu dockerApiContainerCpu = new DockerApiContainerCpu(metricsService, bootstrapConfiguration);
        DockerApiContainerProcess dockerApiContainerProcess = new DockerApiContainerProcess(metricsService, new DockerProcessRankingMethod<DockerApiContainerMetricsRawData>(), processProperties, dockerMonitorConfig, factory);
        DockerApiContainerMemory dockerApiContainerMemory = new DockerApiContainerMemory(metricsService, machineProperties);
        DockerApiContainerDisk dockerApiContainerDisk = new DockerApiContainerDisk(metricsService);
        this.containerComponentMap = new EnumMap(ContainerComponentName.class);
        this.containerComponentMap.put(ContainerComponentName.PROCESS, dockerApiContainerProcess);
        this.containerComponentMap.put(ContainerComponentName.CPUS, dockerApiContainerCpu);
        this.containerComponentMap.put(ContainerComponentName.MEMORY, dockerApiContainerMemory);
        this.containerComponentMap.put(ContainerComponentName.DISK, dockerApiContainerDisk);
        this.containerComponentMap.put(ContainerComponentName.NETWORK, dockerApiContainerNetworks);
    }

    @Override
    public Set<ContainerComponentName> report(Set<ContainerComponentName> componentNames) {
        HashSet<ContainerComponentName> successfullyReported = new HashSet<ContainerComponentName>();
        for (ContainerComponentName componentName : componentNames) {
            ContainerComponent<DockerApiContainerMetricsRawData> containerComponent = this.containerComponentMap.get((Object)componentName);
            try {
                if (containerComponent != null) {
                    containerComponent.report();
                    successfullyReported.add(componentName);
                    continue;
                }
                this.repetitiveLogger.warn(log, "Component - {} is not supported", new Object[]{componentName});
            }
            catch (RuntimeException exception) {
                this.repetitiveLogger.debug(log, "Error while reporting data for component - {}, e = {}", new Object[]{componentName, exception.getMessage()});
                this.repetitiveLogger.warn(log, "Error while reporting data for component - {}", new Object[]{componentName});
            }
        }
        return successfullyReported;
    }

    @Override
    public Set<ContainerComponentName> update(DockerApiContainerMetricsRawData dockerApiContainerMetricsRawData, Set<ContainerComponentName> componentNames, MachineProperties serverHostProperties) {
        HashSet<ContainerComponentName> successfullyUpdated = new HashSet<ContainerComponentName>();
        for (ContainerComponentName componentName : componentNames) {
            ContainerComponent<DockerApiContainerMetricsRawData> containerComponent = this.containerComponentMap.get((Object)componentName);
            try {
                if (containerComponent != null) {
                    containerComponent.update(dockerApiContainerMetricsRawData, serverHostProperties);
                    successfullyUpdated.add(componentName);
                    continue;
                }
                this.repetitiveLogger.warn(log, "Component - {} is not supported", new Object[]{componentName});
            }
            catch (RuntimeException exception) {
                this.repetitiveLogger.debug(log, "Error while updating data before reporting for container - {} with component - {}, e = {}", new Object[]{dockerApiContainerMetricsRawData.getContainerHostId(), componentName, exception.getMessage()});
                this.repetitiveLogger.warn(log, "Error while updating data before reporting for container - {} with component - {}", new Object[]{dockerApiContainerMetricsRawData.getContainerHostId(), componentName});
            }
        }
        return successfullyUpdated;
    }

    @Generated
    public DockerApiContainerMetrics(EnumMap<ContainerComponentName, ContainerComponent<DockerApiContainerMetricsRawData>> containerComponentMap, SimAgentRepetitiveLogger repetitiveLogger, BootstrapConfiguration bootstrapConfiguration) {
        this.containerComponentMap = containerComponentMap;
        this.repetitiveLogger = repetitiveLogger;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    @Generated
    public EnumMap<ContainerComponentName, ContainerComponent<DockerApiContainerMetricsRawData>> getContainerComponentMap() {
        return this.containerComponentMap;
    }
}

