/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.model;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.docker.model.DockerApiContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerCpu;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerApiContainerCpu
extends ContainerCpu<DockerApiContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerApiContainerCpu.class);
    private static final String THROTTLING_TIME = "throttled_time";
    private final DeltaCalculatorUtil cpuUsageDeltaCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil systemCpuUsageDeltaCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil throttledTimeDeltaCalculator = new DeltaCalculatorUtil();
    private long hostCpuLogicalCores;

    DockerApiContainerCpu(MetricsService metricsService, BootstrapConfiguration bootstrapConfiguration) {
        super(metricsService, bootstrapConfiguration);
    }

    @Override
    public void update(DockerApiContainerMetricsRawData rawData, MachineProperties serverHostProperties) {
        DockerApiContainerMetricsRawData.Cpus cpu = rawData.getCpus();
        this.cpuUsageDeltaCalculator.calculate(cpu.getCpuUsageStats().getCpuUsage());
        this.systemCpuUsageDeltaCalculator.calculate(cpu.getSystemCpuUsage());
        Map throttlingData = cpu.getThrottlingData();
        if (throttlingData != null) {
            this.throttledTimeDeltaCalculator.calculate(((Long)throttlingData.get(THROTTLING_TIME)).longValue());
        }
        this.hostCpuLogicalCores = this.calculateHostLogicalCores(serverHostProperties.toMap());
    }

    @VisibleForTesting
    double getCpuUsageRaw() {
        double cpuPercent = 0.0;
        long cpuUsageDelta = this.cpuUsageDeltaCalculator.getLastResult();
        long systemCpuUsageDelta = this.systemCpuUsageDeltaCalculator.getLastResult();
        if ((double)systemCpuUsageDelta > 0.0 && (double)cpuUsageDelta > 0.0) {
            cpuPercent = (double)cpuUsageDelta / (double)systemCpuUsageDelta * 100.0;
        }
        return cpuPercent;
    }

    @Override
    public Optional<Long> getCpuBusy() {
        double cpuUsage = this.getCpuUsageRaw();
        long cpuLogicalCore = this.getHostCpuLogicalCores();
        double containerCpuUsage = cpuUsage * (double)cpuLogicalCore;
        return Optional.fromNullable((Object)Math.round(containerCpuUsage));
    }

    @Override
    public Optional<Long> getCpuBusyScaled() {
        return this.getCpuBusy();
    }

    @Override
    public Optional<Long> getCpuThrottledTime() {
        return Optional.fromNullable((Object)this.throttledTimeDeltaCalculator.getLastResult());
    }

    @VisibleForTesting
    long getHostCpuLogicalCores() {
        return this.hostCpuLogicalCores;
    }
}

