/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.dockerapi.collector;

import com.appdynamics.agent.sim.docker.DockerService;
import com.appdynamics.agent.sim.docker.model.ContainerProcess;
import com.appdynamics.agent.sim.docker.model.DockerApiContainerMetricsRawData;
import com.appdynamics.agent.sim.docker.model.IContainerProcessDtoFactory;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerProcessMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.model.DockerProcessClassIdCreator;
import com.appdynamics.sim.agent.extensions.docker.util.NixProcessStateUtil;
import com.appdynamics.sim.agent.extensions.docker.util.NixUtils;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DockerApiMetricCollectionCallable
implements Callable<Map<String, DockerApiContainerMetricsRawData>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerApiMetricCollectionCallable.class);
    private final String containerId;
    private final String containerHostId;
    private final DockerService dockerService;
    private IContainerProcessDtoFactory containerProcessDtoFactory;
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider;
    private final DockerProcessClassIdCreator processClassIdCreator;
    private final NixProcessStateUtil procStateUtil;

    public DockerApiMetricCollectionCallable(IContainerProcessDtoFactory containerProcessDtoFactory, Provider<DockerMonitorConfig> dockerMonitorConfigProvider, DockerProcessClassIdCreator processClassIdCreator, @NonNull NixProcessStateUtil procStateUtil, String containerId, String containerHostId, DockerService dockerService) {
        if (procStateUtil == null) {
            throw new NullPointerException("procStateUtil is marked non-null but is null");
        }
        this.containerProcessDtoFactory = containerProcessDtoFactory;
        this.dockerMonitorConfigProvider = dockerMonitorConfigProvider;
        this.processClassIdCreator = processClassIdCreator;
        this.procStateUtil = procStateUtil;
        this.containerId = containerId;
        this.containerHostId = containerHostId;
        this.dockerService = dockerService;
    }

    @Override
    public Map<String, DockerApiContainerMetricsRawData> call() throws Exception {
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        DockerApiContainerMetricsRawData containerMetricsRawData = new DockerApiContainerMetricsRawData();
        boolean addRawDataToResult = false;
        try {
            containerMetricsRawData = this.dockerService.getContainerMetricsRawData(this.containerId);
            addRawDataToResult = true;
            log.trace("Successfully retrieved container metrics for containerId {} - {}", (Object)this.containerId, (Object)containerMetricsRawData);
        }
        catch (Exception e) {
            log.error("Failed collection metric for containerId: {} with error: {}", (Object)this.containerId, (Object)e);
        }
        try {
            containerMetricsRawData.setContainerHostId(this.containerHostId);
            if (((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig().getEnabled().booleanValue()) {
                this.collectProcessObservationAndUpdateToRawData(containerMetricsRawData);
                addRawDataToResult = true;
                log.trace("Successfully retrieved container processes for containerId {} - {}", (Object)this.containerId, (Object)containerMetricsRawData);
            }
        }
        catch (Exception e) {
            log.error("Failed process collection for containerId: {} with error: {}", (Object)this.containerId, (Object)e);
        }
        if (addRawDataToResult) {
            resultBuilder.put((Object)this.containerId, (Object)containerMetricsRawData);
        }
        return resultBuilder.build();
    }

    private void collectProcessObservationAndUpdateToRawData(DockerApiContainerMetricsRawData containerMetricsRawData) {
        List processes;
        try {
            processes = this.containerProcessDtoFactory.convertToContainerProcesses(this.dockerService.getProcessesForContainer(this.containerId));
        }
        catch (RuntimeException e) {
            log.warn("The docker service did not find processes for container with id {}", (Object)this.containerId);
            return;
        }
        this.updateObservationsToRawData(processes, containerMetricsRawData);
    }

    private void updateObservationsToRawData(List<ContainerProcess> processes, DockerApiContainerMetricsRawData containerMetricsRawData) {
        HashMap<Long, SimProcessObservationDto> pidToSimProcessObservationDto = new HashMap<Long, SimProcessObservationDto>();
        HashMap<Long, ContainerProcess> pidToContainerProcessMap = new HashMap<Long, ContainerProcess>();
        DockerProcessMonitorConfig processMonitorConfig = ((DockerMonitorConfig)this.dockerMonitorConfigProvider.get()).getProcessMonitorConfig();
        long minLiveTime = processMonitorConfig.getMinLiveTimeMillisBeforeMonitoring();
        for (ContainerProcess process : processes) {
            DockerProcessClassIdCreator.DockerProcessClass processClass = this.processClassIdCreator.extractClass(process.getCommandLine(), process.getName());
            long elapsedTimeInMillis = 0L;
            try {
                elapsedTimeInMillis = NixUtils.getTimeInMilis(process.getElapsedTime());
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                log.warn(ex.getMessage());
            }
            SimProcessObservationDto observation = new SimProcessObservationDto(elapsedTimeInMillis, processClass.getProcessClassId(), processClass.getProcessClass(), process.getName(), process.getPid().longValue(), process.getParentId().longValue(), process.getCommandLine(), process.getRealUser(), this.procStateUtil.getProcessState(process.getState()), this.buildOsRelatedProcessProperties(process));
            if (observation.getLiveTime() < minLiveTime) continue;
            pidToSimProcessObservationDto.put(process.getPid(), observation);
            pidToContainerProcessMap.put(process.getPid(), process);
        }
        containerMetricsRawData.setPidToSimProcessObservationDto(pidToSimProcessObservationDto);
        containerMetricsRawData.setPidToContainerProcessMap(pidToContainerProcessMap);
    }

    private Map<String, String> buildOsRelatedProcessProperties(ContainerProcess process) {
        ImmutableMap.Builder propertyBuilder = ImmutableMap.builder();
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.EFFECTIVE_GROUP.getKey(), (Object)process.getEffectiveGroup());
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.NICE_LEVEL.getKey(), (Object)process.getNice());
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.PGID.getKey(), (Object)Long.toString(process.getParentGroupId()));
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.REAL_GROUP.getKey(), (Object)process.getRealGroup());
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.REAL_USER.getKey(), (Object)process.getRealUser());
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.CONTAINER_ID.getKey(), (Object)this.containerHostId);
        return propertyBuilder.build();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerApiMetricCollectionCallable)) {
            return false;
        }
        DockerApiMetricCollectionCallable other = (DockerApiMetricCollectionCallable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$containerId = this.containerId;
        String other$containerId = other.containerId;
        if (this$containerId == null ? other$containerId != null : !this$containerId.equals(other$containerId)) {
            return false;
        }
        String this$containerHostId = this.containerHostId;
        String other$containerHostId = other.containerHostId;
        if (this$containerHostId == null ? other$containerHostId != null : !this$containerHostId.equals(other$containerHostId)) {
            return false;
        }
        DockerService this$dockerService = this.dockerService;
        DockerService other$dockerService = other.dockerService;
        if (this$dockerService == null ? other$dockerService != null : !this$dockerService.equals(other$dockerService)) {
            return false;
        }
        IContainerProcessDtoFactory this$containerProcessDtoFactory = this.containerProcessDtoFactory;
        IContainerProcessDtoFactory other$containerProcessDtoFactory = other.containerProcessDtoFactory;
        if (this$containerProcessDtoFactory == null ? other$containerProcessDtoFactory != null : !this$containerProcessDtoFactory.equals(other$containerProcessDtoFactory)) {
            return false;
        }
        Provider<DockerMonitorConfig> this$dockerMonitorConfigProvider = this.dockerMonitorConfigProvider;
        Provider<DockerMonitorConfig> other$dockerMonitorConfigProvider = other.dockerMonitorConfigProvider;
        if (this$dockerMonitorConfigProvider == null ? other$dockerMonitorConfigProvider != null : !this$dockerMonitorConfigProvider.equals(other$dockerMonitorConfigProvider)) {
            return false;
        }
        DockerProcessClassIdCreator this$processClassIdCreator = this.processClassIdCreator;
        DockerProcessClassIdCreator other$processClassIdCreator = other.processClassIdCreator;
        if (this$processClassIdCreator == null ? other$processClassIdCreator != null : !this$processClassIdCreator.equals(other$processClassIdCreator)) {
            return false;
        }
        NixProcessStateUtil this$procStateUtil = this.procStateUtil;
        NixProcessStateUtil other$procStateUtil = other.procStateUtil;
        return !(this$procStateUtil == null ? other$procStateUtil != null : !this$procStateUtil.equals(other$procStateUtil));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DockerApiMetricCollectionCallable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $containerId = this.containerId;
        result = result * 59 + ($containerId == null ? 43 : $containerId.hashCode());
        String $containerHostId = this.containerHostId;
        result = result * 59 + ($containerHostId == null ? 43 : $containerHostId.hashCode());
        DockerService $dockerService = this.dockerService;
        result = result * 59 + ($dockerService == null ? 43 : $dockerService.hashCode());
        IContainerProcessDtoFactory $containerProcessDtoFactory = this.containerProcessDtoFactory;
        result = result * 59 + ($containerProcessDtoFactory == null ? 43 : $containerProcessDtoFactory.hashCode());
        Provider<DockerMonitorConfig> $dockerMonitorConfigProvider = this.dockerMonitorConfigProvider;
        result = result * 59 + ($dockerMonitorConfigProvider == null ? 43 : $dockerMonitorConfigProvider.hashCode());
        DockerProcessClassIdCreator $processClassIdCreator = this.processClassIdCreator;
        result = result * 59 + ($processClassIdCreator == null ? 43 : $processClassIdCreator.hashCode());
        NixProcessStateUtil $procStateUtil = this.procStateUtil;
        result = result * 59 + ($procStateUtil == null ? 43 : $procStateUtil.hashCode());
        return result;
    }

    static enum DockerContainerProcessPropertyKey {
        CONTAINER_ID("Container|Id"),
        EFFECTIVE_GROUP("effectiveGroup"),
        NICE_LEVEL("niceLevel"),
        PGID("pgid"),
        REAL_USER("realUser"),
        REAL_GROUP("realGroup");

        private final String key;

        @Generated
        private DockerContainerProcessPropertyKey(String key) {
            this.key = key;
        }

        @Generated
        public String getKey() {
            return this.key;
        }
    }
}

