/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorForOptionalUtil;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorForOptionalUtil;
import com.appdynamics.sim.agent.extensions.api.util.SizeUnitUtil;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerNetwork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import lombok.NonNull;

public class CGroupContainerNetwork
extends ContainerNetwork<CGroupContainerMetricsRawData> {
    private final DeltaCalculatorForOptionalUtil incomingBytesCalculator;
    private final DeltaCalculatorForOptionalUtil outgoingBytesCalculator;
    private final DeltaCalculatorForOptionalUtil incomingPacketsCalculator;
    private final DeltaCalculatorForOptionalUtil outgoingPacketsCalculator;
    private final DeltaCalculatorForOptionalUtil incomingErrorsCalculator;
    private final DeltaCalculatorForOptionalUtil outgoingErrorsCalculator;
    private final DeltaCalculatorForOptionalUtil incomingDroppedPacketsCalculator;
    private final DeltaCalculatorForOptionalUtil outgoingDroppedPacketsCalculator;
    private final RateCalculatorForOptionalUtil incomingBytesPerSecCalculator;
    private final RateCalculatorForOptionalUtil outgoingBytesPerSecCalculator;

    CGroupContainerNetwork(@NonNull String networkName, @NonNull MetricsService metricsService) {
        super(networkName, metricsService);
        if (networkName == null) {
            throw new NullPointerException("networkName is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        this.incomingBytesCalculator = new DeltaCalculatorForOptionalUtil();
        this.outgoingBytesCalculator = new DeltaCalculatorForOptionalUtil();
        this.incomingPacketsCalculator = new DeltaCalculatorForOptionalUtil();
        this.outgoingPacketsCalculator = new DeltaCalculatorForOptionalUtil();
        this.incomingErrorsCalculator = new DeltaCalculatorForOptionalUtil();
        this.outgoingErrorsCalculator = new DeltaCalculatorForOptionalUtil();
        this.incomingDroppedPacketsCalculator = new DeltaCalculatorForOptionalUtil();
        this.outgoingDroppedPacketsCalculator = new DeltaCalculatorForOptionalUtil();
        this.incomingBytesPerSecCalculator = new RateCalculatorForOptionalUtil();
        this.outgoingBytesPerSecCalculator = new RateCalculatorForOptionalUtil();
    }

    @Override
    public void update(CGroupContainerMetricsRawData rawData, MachineProperties machineProperties) {
        CGroupContainerMetricsRawData.CGroupNetworkData networkInfo = rawData.getCGroupContainerNetworks().get(this.networkName);
        this.incomingBytesCalculator.calculate(networkInfo.getRxBytes());
        this.outgoingBytesCalculator.calculate(networkInfo.getTxBytes());
        this.incomingPacketsCalculator.calculate(networkInfo.getRxPackets());
        this.outgoingPacketsCalculator.calculate(networkInfo.getTxPackets());
        this.incomingErrorsCalculator.calculate(networkInfo.getRxErrors());
        this.outgoingErrorsCalculator.calculate(networkInfo.getTxErrors());
        this.incomingDroppedPacketsCalculator.calculate(networkInfo.getRxDropped());
        this.outgoingDroppedPacketsCalculator.calculate(networkInfo.getTxDropped());
        this.incomingBytesPerSecCalculator.calculate(networkInfo.getRxBytes(), networkInfo.getTimestampInSeconds());
        this.outgoingBytesPerSecCalculator.calculate(networkInfo.getTxBytes(), networkInfo.getTimestampInSeconds());
    }

    @Override
    protected Optional<Long> getIncomingKb() {
        return this.toKiloUnitsOptional((Optional<Long>)this.incomingBytesCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getOutgoingKb() {
        return this.toKiloUnitsOptional((Optional<Long>)this.outgoingBytesCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getIncomingKbPerSec() {
        return this.toKiloUnitsOptional((Optional<Long>)this.incomingBytesPerSecCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getOutgoingKbPerSec() {
        return this.toKiloUnitsOptional((Optional<Long>)this.outgoingBytesPerSecCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getIncomingPackets() {
        return this.incomingPacketsCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getOutgoingPackets() {
        return this.outgoingPacketsCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getIncomingErrors() {
        return this.incomingErrorsCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getOutgoingErrors() {
        return this.outgoingErrorsCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getIncomingPacketsDropped() {
        return this.incomingDroppedPacketsCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getOutgoingPacketsDropped() {
        return this.outgoingDroppedPacketsCalculator.getLastResult();
    }

    @VisibleForTesting
    Optional<Long> toKiloUnitsOptional(Optional<Long> valueOptional) {
        return valueOptional.isPresent() ? Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)((Long)valueOptional.get()))) : valueOptional;
    }
}

