/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessProperties;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerCpu;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerDisk;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMemory;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerNetworks;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerProcess;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerComponent;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerMetrics;
import com.appdynamics.sim.agent.extensions.docker.model.filter.DockerProcessRankingMethod;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupContainerMetrics
implements ContainerMetrics<CGroupContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupContainerMetrics.class);
    private final Map<ContainerComponentName, ContainerComponent<CGroupContainerMetricsRawData>> containerComponentMap;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    public CGroupContainerMetrics(@Assisted @NonNull MetricsService metricsService, @Assisted @NonNull MachineProperties machineProperties, SimAgentRepetitiveLogger repetitiveLogger, BootstrapConfiguration bootstrapConfiguration, Provider<DockerMonitorConfig> dockerMonitorConfig, @NonNull DockerProcessProperties processProperties, @NonNull RawDataFactory factory) {
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.repetitiveLogger = repetitiveLogger;
        this.bootstrapConfiguration = bootstrapConfiguration;
        CGroupContainerProcess cGroupContainerProcess = new CGroupContainerProcess(metricsService, new DockerProcessRankingMethod<CGroupContainerMetricsRawData>(), processProperties, dockerMonitorConfig, factory);
        CGroupContainerCpu cGroupContainerCpu = new CGroupContainerCpu(metricsService, bootstrapConfiguration);
        CGroupContainerMemory cGroupContainerMemory = new CGroupContainerMemory(metricsService, machineProperties);
        CGroupContainerNetworks cGroupContainerNetworks = new CGroupContainerNetworks(metricsService, machineProperties);
        CGroupContainerDisk cGroupContainerDisk = new CGroupContainerDisk(metricsService);
        this.containerComponentMap = new HashMap<ContainerComponentName, ContainerComponent<CGroupContainerMetricsRawData>>();
        this.containerComponentMap.put(ContainerComponentName.CPUS, cGroupContainerCpu);
        this.containerComponentMap.put(ContainerComponentName.PROCESS, cGroupContainerProcess);
        this.containerComponentMap.put(ContainerComponentName.MEMORY, cGroupContainerMemory);
        this.containerComponentMap.put(ContainerComponentName.NETWORK, cGroupContainerNetworks);
        this.containerComponentMap.put(ContainerComponentName.DISK, cGroupContainerDisk);
    }

    @Override
    public Set<ContainerComponentName> report(Set<ContainerComponentName> componentNames) {
        HashSet<ContainerComponentName> successfullyReported = new HashSet<ContainerComponentName>();
        for (ContainerComponentName componentName : componentNames) {
            ContainerComponent<CGroupContainerMetricsRawData> containerComponent = this.containerComponentMap.get((Object)componentName);
            try {
                if (containerComponent != null) {
                    containerComponent.report();
                    successfullyReported.add(componentName);
                    continue;
                }
                this.repetitiveLogger.warn(log, "Component - {} is not supported", new Object[]{componentName});
            }
            catch (RuntimeException exception) {
                this.repetitiveLogger.debug(log, "Error while reporting data for component - {}, e = {}", new Object[]{componentName, exception.getMessage()});
                this.repetitiveLogger.warn(log, "Error while reporting data for component - {}", new Object[]{componentName});
            }
        }
        return successfullyReported;
    }

    @Override
    public Set<ContainerComponentName> update(CGroupContainerMetricsRawData containerMetricsRawData, Set<ContainerComponentName> componentNames, MachineProperties serverHostProperties) {
        HashSet<ContainerComponentName> successfullyUpdated = new HashSet<ContainerComponentName>();
        for (ContainerComponentName componentName : componentNames) {
            ContainerComponent<CGroupContainerMetricsRawData> containerComponent = this.containerComponentMap.get((Object)componentName);
            try {
                if (containerComponent != null) {
                    containerComponent.update(containerMetricsRawData, serverHostProperties);
                    successfullyUpdated.add(componentName);
                    continue;
                }
                this.repetitiveLogger.warn(log, "Component - {} is not supported", new Object[]{componentName});
            }
            catch (RuntimeException exception) {
                this.repetitiveLogger.debug(log, "Error while updating data before reporting for container - {} with component - {}, e = {}", new Object[]{containerMetricsRawData.getContainerHostId(), componentName, exception.getMessage()});
                this.repetitiveLogger.warn(log, "Error while updating data before reporting for container - {} with component - {}", new Object[]{containerMetricsRawData.getContainerHostId(), componentName});
            }
        }
        return successfullyUpdated;
    }

    @Generated
    public CGroupContainerMetrics(Map<ContainerComponentName, ContainerComponent<CGroupContainerMetricsRawData>> containerComponentMap, SimAgentRepetitiveLogger repetitiveLogger, BootstrapConfiguration bootstrapConfiguration) {
        this.containerComponentMap = containerComponentMap;
        this.repetitiveLogger = repetitiveLogger;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }
}

