/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorForOptionalUtil;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerCpu;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupContainerCpu
extends ContainerCpu<CGroupContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupContainerCpu.class);
    private final DeltaCalculatorForOptionalUtil cpuUsageDeltaCalculator = new DeltaCalculatorForOptionalUtil();
    private final DeltaCalculatorForOptionalUtil systemCpuUsageDeltaCalculator = new DeltaCalculatorForOptionalUtil();
    private final DeltaCalculatorForOptionalUtil throttledTimeDeltaCalculator = new DeltaCalculatorForOptionalUtil();
    private CGroupContainerMetricsRawData.CGroupCPUData cpu;
    private long hostCpuLogicalCores;

    CGroupContainerCpu(MetricsService metricsService, BootstrapConfiguration bootstrapConfiguration) {
        super(metricsService, bootstrapConfiguration);
    }

    @Override
    public void update(CGroupContainerMetricsRawData rawData, MachineProperties serverHostProperties) {
        this.cpu = rawData.getCGroupCPUData();
        this.cpuUsageDeltaCalculator.calculate(this.cpu.getCpuTotalUsage());
        this.systemCpuUsageDeltaCalculator.calculate(this.cpu.getCpuUsageSystem());
        this.throttledTimeDeltaCalculator.calculate(this.cpu.getThrottledTime());
        this.hostCpuLogicalCores = this.calculateHostLogicalCores(serverHostProperties.toMap());
    }

    @VisibleForTesting
    Optional<Double> getCpuUsageRaw() {
        double cpuPercent = 0.0;
        Optional cpuUsageDelta = this.cpuUsageDeltaCalculator.getLastResult();
        Optional systemCpuUsageDelta = this.systemCpuUsageDeltaCalculator.getLastResult();
        if (cpuUsageDelta.isPresent() && systemCpuUsageDelta.isPresent()) {
            if ((double)((Long)systemCpuUsageDelta.get()).longValue() > 0.0 && (double)((Long)cpuUsageDelta.get()).longValue() > 0.0) {
                cpuPercent = (double)((Long)cpuUsageDelta.get()).longValue() / (double)((Long)systemCpuUsageDelta.get()).longValue() * 100.0;
            }
            return Optional.of((Object)cpuPercent);
        }
        return Optional.absent();
    }

    @Override
    public Optional<Long> getCpuBusyScaled() {
        Optional<Double> cpuUsage = this.getCpuUsageRaw();
        long cpuLogicalCore = this.getHostCpuLogicalCores();
        if (cpuUsage.isPresent()) {
            double scaledCpuUsage = (Double)cpuUsage.get() * (double)cpuLogicalCore;
            return Optional.fromNullable((Object)Math.round(scaledCpuUsage));
        }
        return Optional.absent();
    }

    @Override
    public Optional<Long> getCpuBusy() {
        Optional<Double> cpuUsage = this.getCpuUsageRaw();
        if (cpuUsage.isPresent()) {
            return this.getCpuBusyScaled();
        }
        return Optional.absent();
    }

    @Override
    public Optional<Long> getCpuThrottledTime() {
        return this.throttledTimeDeltaCalculator.getLastResult();
    }

    @VisibleForTesting
    long getHostCpuLogicalCores() {
        return this.hostCpuLogicalCores;
    }
}

