/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.agent.sim.docker.model.ContainerProcess;
import com.appdynamics.agent.sim.utils.BashPathProvider;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerProcessMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupComponentCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileReader;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.docker.model.DockerProcessClassIdCreator;
import com.appdynamics.sim.agent.extensions.docker.util.NixProcessStateUtil;
import com.appdynamics.sim.agent.extensions.docker.util.NixUtils;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupProcessCollector
implements CGroupComponentCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupProcessCollector.class);
    private static final String PROC_DIR = "/proc/";
    private static final String CMDLINE = "/cmdline";
    private static final String STATUS = "/status";
    private static final String STAT = "/stat";
    private static final String PS_COMMAND = "/bin/ps -w -o comm -o euser:30 -o egroup:30 -o ruser:30 -o rgroup:30 -o pid o %mem -o %cpu -o cputime -o etime -o nice -o maj_flt -o min_flt -o nlwp -o pgid -o ppid -o rss -o stat -o vsize -o args -p ";
    private static final int PS_COMMAND_OUTPUT_ARGS_COUNT = 20;
    private static final String PS_COMMAND_SEPERATOR = "\"|\"";
    private static final String PS_COMMAND_AWK_SEPERATOR = "| awk 'BEGIN {OFS=\"|\"} {command=\"\"; for (i=20; i<=NF; i++) command=command $i \" \"; print $1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, command}'";
    private final CGroupFileReader cGroupFileReader;
    private final Provider<DockerMonitorConfig> dockerMonitorConfigProvider;
    private final Long minLiveTime;
    private final DockerProcessClassIdCreator processClassIdCreator;
    private final NixProcessStateUtil procStateUtil;
    private String containerHostId = "";

    @Inject
    @VisibleForTesting
    CGroupProcessCollector(CGroupFileReader cGroupFileReader, Provider<DockerMonitorConfig> dockerMonitorConfigProvider, DockerProcessClassIdCreator processClassIdCreator, @NonNull NixProcessStateUtil procStateUtil) {
        if (procStateUtil == null) {
            throw new NullPointerException("procStateUtil is marked non-null but is null");
        }
        this.cGroupFileReader = cGroupFileReader;
        this.dockerMonitorConfigProvider = dockerMonitorConfigProvider;
        this.processClassIdCreator = processClassIdCreator;
        this.procStateUtil = procStateUtil;
        DockerProcessMonitorConfig processMonitorConfig = ((DockerMonitorConfig)dockerMonitorConfigProvider.get()).getProcessMonitorConfig();
        this.minLiveTime = processMonitorConfig.getMinLiveTimeMillisBeforeMonitoring();
    }

    @Override
    public void collectAndUpdate(String containerId, CGroupContainerMetricsRawData cGroupContainerMetricsRawData) {
        HashMap<Long, SimProcessObservationDto> pidToSimProcessObservationDto = new HashMap<Long, SimProcessObservationDto>();
        HashMap<Long, ContainerProcess> pidToContainerProcessMap = new HashMap<Long, ContainerProcess>();
        this.containerHostId = cGroupContainerMetricsRawData.getContainerHostId();
        List<String> processPidsMap = this.cGroupFileReader.getFileLines(containerId, "cgroup.procs");
        StringBuilder pidsBuilder = new StringBuilder();
        for (String pidStr : processPidsMap) {
            if (pidStr == null || pidStr.trim().isEmpty()) continue;
            if (pidsBuilder.length() > 0) {
                pidsBuilder.append(",");
            }
            pidsBuilder.append(pidStr.trim());
        }
        String pids = pidsBuilder.toString();
        if (!pids.isEmpty()) {
            String command = "unknown";
            String effectiveUser = "";
            String effectiveGroup = "";
            String realUser = "";
            String realGroup = "";
            Long pid = -1L;
            String memoryPercent = "0.0";
            String cpuPercent = "0.0";
            String cpuTime = "00:00:00";
            String elapsedTime = "00:00:00";
            String nice = "0";
            Long majorFaults = 0L;
            Long minorFaults = 0L;
            Long threadCount = 0L;
            Long parentPid = -1L;
            Long parentGroupId = -1L;
            Long memoryUsedKb = 0L;
            String state = "";
            Long virtualMemSizeKb = 0L;
            String name = "unknown";
            try (InputStream inputStream = new ProcessBuilder(BashPathProvider.getBashPath(), "-c", PS_COMMAND + pids + PS_COMMAND_AWK_SEPERATOR).start().getInputStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String header = bufferedReader.readLine();
                log.debug("Process header : " + header);
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    try {
                        ContainerProcess containerProcess;
                        SimProcessObservationDto observationDto;
                        log.debug("Process : " + line);
                        String[] tokens = line.split("[\"|\"]");
                        if (tokens.length == 20) {
                            name = tokens[0].trim();
                            effectiveUser = tokens[1].trim();
                            effectiveGroup = tokens[2].trim();
                            realUser = tokens[3].trim();
                            realGroup = tokens[4].trim();
                            pid = Long.parseLong(tokens[5].trim());
                            memoryPercent = tokens[6].trim();
                            cpuPercent = tokens[7].trim();
                            cpuTime = tokens[8].trim();
                            elapsedTime = tokens[9].trim();
                            nice = tokens[10].trim();
                            majorFaults = Long.parseLong(tokens[11].trim());
                            minorFaults = Long.parseLong(tokens[12].trim());
                            threadCount = Long.parseLong(tokens[13].trim());
                            parentGroupId = Long.parseLong(tokens[14].trim());
                            parentPid = Long.parseLong(tokens[15].trim());
                            memoryUsedKb = Long.parseLong(tokens[16].trim());
                            state = tokens[17].trim();
                            virtualMemSizeKb = Long.parseLong(tokens[18].trim());
                            command = tokens[19].trim();
                        }
                        if ((observationDto = this.updateObservationsToRawData(containerProcess = new ContainerProcess(command, effectiveUser, effectiveGroup, realUser, realGroup, pid, memoryPercent, cpuPercent, cpuTime, elapsedTime, nice, majorFaults, minorFaults, threadCount, parentGroupId, parentPid, memoryUsedKb, state, virtualMemSizeKb, name))) != null) {
                            pidToContainerProcessMap.put(pid, containerProcess);
                            pidToSimProcessObservationDto.put(pid, observationDto);
                            log.debug("Process name {}, added for monitoring", (Object)name);
                            continue;
                        }
                        log.debug("Process name {}, not added for monitoring", (Object)name);
                    }
                    catch (Exception e) {
                        log.debug("Error while creating container process and observation data for containerId {} pid {} using ps command using cgroup, {}", new Object[]{containerId, pid, e.getMessage()});
                    }
                }
            }
            catch (Exception e) {
                log.debug("Error while getting process data for containerId {} using ps command using cgroup, {}", (Object)containerId, (Object)e.getMessage());
            }
        }
        cGroupContainerMetricsRawData.setPidToContainerProcessMap(pidToContainerProcessMap);
        cGroupContainerMetricsRawData.setPidToSimProcessObservationDto(pidToSimProcessObservationDto);
    }

    private SimProcessObservationDto updateObservationsToRawData(ContainerProcess process) {
        DockerProcessClassIdCreator.DockerProcessClass processClass = this.processClassIdCreator.extractClass(process.getCommandLine(), process.getName());
        long elapsedTimeInMillis = 0L;
        try {
            elapsedTimeInMillis = NixUtils.getTimeInMilis(process.getElapsedTime());
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn(ex.getMessage());
        }
        SimProcessObservationDto observation = new SimProcessObservationDto(elapsedTimeInMillis, processClass.getProcessClassId(), processClass.getProcessClass(), process.getName(), process.getPid().longValue(), process.getParentId().longValue(), process.getCommandLine(), process.getRealUser(), this.procStateUtil.getProcessState(process.getState()), this.buildOsRelatedProcessProperties(process));
        if (observation.getLiveTime() < this.minLiveTime) {
            return null;
        }
        return observation;
    }

    private Map<String, String> buildOsRelatedProcessProperties(ContainerProcess process) {
        ImmutableMap.Builder propertyBuilder = ImmutableMap.builder();
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.EFFECTIVE_GROUP.getKey(), (Object)process.getEffectiveGroup());
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.NICE_LEVEL.getKey(), (Object)process.getNice());
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.PGID.getKey(), (Object)Long.toString(process.getParentGroupId()));
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.REAL_GROUP.getKey(), (Object)process.getRealGroup());
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.REAL_USER.getKey(), (Object)process.getRealUser());
        propertyBuilder.put((Object)DockerContainerProcessPropertyKey.CONTAINER_ID.getKey(), (Object)this.containerHostId);
        return propertyBuilder.build();
    }

    static enum DockerContainerProcessPropertyKey {
        CONTAINER_ID("Container|Id"),
        EFFECTIVE_GROUP("effectiveGroup"),
        NICE_LEVEL("niceLevel"),
        PGID("pgid"),
        REAL_USER("realUser"),
        REAL_GROUP("realGroup");

        private final String key;

        @Generated
        private DockerContainerProcessPropertyKey(String key) {
            this.key = key;
        }

        @Generated
        public String getKey() {
            return this.key;
        }
    }
}

