/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.docker.ContainerPropertiesRegistry;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupComponentCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileReader;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.model.CGroupContainerMetricsRawData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupNetworkCollector
implements CGroupComponentCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupNetworkCollector.class);
    private static final String PROC_NETWORK_DEV_PATH = "/proc/%s/net/dev";
    private static final String IFACE_SEPARATOR = ":";
    private static final String WHITE_SPACE_PATTERN = "\\s+";
    private static final String LOOPBACK_INTERFACE_NAME = "lo";
    private static final String TUNNEL_INTERFACE_PREFIX = "tunl";
    private final CGroupFileReader fileReader;
    private final ContainerPropertiesRegistry containerPropertiesRegistry;
    private final SimAgentRepetitiveLogger simAgentRepetitiveLogger;

    @Inject
    public CGroupNetworkCollector(CGroupFileReader fileReader, ContainerPropertiesRegistry containerPropertiesRegistry, SimAgentRepetitiveLogger simAgentRepetitiveLogger) {
        this.fileReader = fileReader;
        this.containerPropertiesRegistry = containerPropertiesRegistry;
        this.simAgentRepetitiveLogger = simAgentRepetitiveLogger;
    }

    @Override
    public void collectAndUpdate(String containerId, CGroupContainerMetricsRawData cGroupContainerMetricsRawData) {
        Map<String, CGroupContainerMetricsRawData.CGroupNetworkData> networkData = this.collectNetworkMetrics(containerId);
        cGroupContainerMetricsRawData.setCGroupContainerNetworks(networkData);
    }

    public Map<String, CGroupContainerMetricsRawData.CGroupNetworkData> collectNetworkMetrics(String containerId) {
        Optional<Long> containerPidOptional = this.containerPropertiesRegistry.getContainerPid(containerId);
        if (!containerPidOptional.isPresent()) {
            this.simAgentRepetitiveLogger.warn(log, "PID is not available for container Id : {}. Skipping network metric collection using cgroups", new Object[]{containerId});
            return ImmutableMap.of();
        }
        String containerNetworkFilePath = String.format(PROC_NETWORK_DEV_PATH, containerPidOptional.get());
        return this.readNetworkMetricsFromFile(containerNetworkFilePath);
    }

    @VisibleForTesting
    Map<String, CGroupContainerMetricsRawData.CGroupNetworkData> readNetworkMetricsFromFile(String filePath) {
        long timestampInSeconds = this.getTimeStampInSeconds();
        HashMap<String, CGroupContainerMetricsRawData.CGroupNetworkData> networkDataMap = new HashMap<String, CGroupContainerMetricsRawData.CGroupNetworkData>();
        List<String> lines = this.fileReader.getFileLines(filePath);
        for (String line : lines) {
            String metricData;
            String[] metrics;
            String ifaceName;
            String[] ifaceNameAndMetrics;
            String currentLine = line.trim();
            if (currentLine.indexOf(IFACE_SEPARATOR) == -1 || (ifaceNameAndMetrics = currentLine.split(IFACE_SEPARATOR)).length != 2 || (ifaceName = ifaceNameAndMetrics[0]) != null && (ifaceName.equals(LOOPBACK_INTERFACE_NAME) || ifaceName.startsWith(TUNNEL_INTERFACE_PREFIX)) || (metrics = (metricData = ifaceNameAndMetrics[1].trim()).split(WHITE_SPACE_PATTERN)).length != 16) continue;
            CGroupContainerMetricsRawData.CGroupNetworkData networkInfo = new CGroupContainerMetricsRawData.CGroupNetworkData();
            int index = 0;
            networkInfo.setTimestampInSeconds(timestampInSeconds);
            networkInfo.setRxBytes((Optional<Long>)Optional.of((Object)Long.valueOf(metrics[index])));
            networkInfo.setTxBytes((Optional<Long>)Optional.of((Object)Long.valueOf(metrics[index + 8])));
            networkInfo.setRxPackets((Optional<Long>)Optional.of((Object)Long.valueOf(metrics[++index])));
            networkInfo.setTxPackets((Optional<Long>)Optional.of((Object)Long.valueOf(metrics[index + 8])));
            networkInfo.setRxErrors((Optional<Long>)Optional.of((Object)Long.valueOf(metrics[++index])));
            networkInfo.setTxErrors((Optional<Long>)Optional.of((Object)Long.valueOf(metrics[index + 8])));
            networkInfo.setRxDropped((Optional<Long>)Optional.of((Object)Long.valueOf(metrics[++index])));
            networkInfo.setTxDropped((Optional<Long>)Optional.of((Object)Long.valueOf(metrics[index + 8])));
            networkDataMap.put(ifaceName, networkInfo);
        }
        return networkDataMap;
    }

    @VisibleForTesting
    long getTimeStampInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }
}

