/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFilePathDictionary;
import com.appdynamics.sim.agent.extensions.docker.metrics.cgroup.collector.CGroupFileSystemPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupFilePathResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CGroupFilePathResolver.class);
    private final CGroupFilePathDictionary cGroupFilePathDictionary;
    private final Optional<String> cGroupFileSystemRoot;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final SimAgentRepetitiveLogger simAgentRepetitiveLogger;
    private final Map<String, Optional<String>> fileNameToPathCache;

    @Inject
    CGroupFilePathResolver(CGroupFilePathDictionary cGroupFilePathDictionary, @CGroupFileSystemPath Optional<String> cGroupFileSystemRoot, BootstrapConfiguration bootstrapConfiguration, SimAgentRepetitiveLogger simAgentRepetitiveLogger) {
        this.cGroupFilePathDictionary = cGroupFilePathDictionary;
        this.cGroupFileSystemRoot = cGroupFileSystemRoot;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.simAgentRepetitiveLogger = simAgentRepetitiveLogger;
        this.fileNameToPathCache = new HashMap<String, Optional<String>>();
    }

    Optional<String> resolveFilePathTemplateByName(@NonNull String fileName, @NonNull String containerId) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (containerId == null) {
            throw new NullPointerException("containerId is marked non-null but is null");
        }
        if (!this.cGroupFileSystemRoot.isPresent()) {
            this.simAgentRepetitiveLogger.error(log, "Could not resolve CGroup file system root path.", new Object[0]);
            this.fileNameToPathCache.put(fileName, (Optional<String>)Optional.absent());
            return Optional.absent();
        }
        Optional filePath = this.fileNameToPathCache.get(fileName);
        if (filePath == null) {
            List<String> paths = this.cGroupFilePathDictionary.getPossiblePathsForFile(fileName);
            if (!paths.isEmpty()) {
                for (String path : paths) {
                    boolean fileExists = this.isCGroupFileExists(this.bootstrapConfiguration.getBindMountOfHostRoot(), (String)this.cGroupFileSystemRoot.get(), path, containerId, fileName);
                    if (!fileExists) continue;
                    filePath = Optional.of((Object)Paths.get((String)this.cGroupFileSystemRoot.get(), path).toString());
                    log.info("CGroup file with name {}, is found in {}/<container_id>", (Object)fileName, filePath.get());
                    this.fileNameToPathCache.put(fileName, (Optional<String>)filePath);
                    break;
                }
            } else {
                log.warn("Could not resolve the possible file paths for the container ID: {} and the file name: {}", (Object)containerId, (Object)fileName);
            }
            if (filePath == null) {
                log.warn("For container ID: {}, CGroup file with name {} could not be found.", (Object)containerId, (Object)fileName);
                this.fileNameToPathCache.put(fileName, (Optional<String>)Optional.absent());
            }
        }
        return filePath;
    }

    @VisibleForTesting
    boolean isCGroupFileExists(String hostRoot, String cGroupFileSystemRoot, String enclosingDirectoryPath, String containerId, String fileName) {
        return Paths.get(hostRoot, cGroupFileSystemRoot, enclosingDirectoryPath, containerId, fileName).toFile().exists();
    }
}

