/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker.metrics;

import com.appdynamics.agent.sim.docker.model.DockerContainerFull;
import com.appdynamics.agent.sim.lightagent.LightAgentRegistry;
import com.appdynamics.agent.sim.lightagent.LightSystemAgent;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.docker.DockerProcessProperties;
import com.appdynamics.sim.agent.extensions.docker.metrics.DockerContainerMetricsFactory;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.docker.metrics.collector.ContainerMetricsRawCollector;
import com.appdynamics.sim.agent.extensions.docker.metrics.model.ContainerMetrics;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerMetricsCollectionManager<RAWDATA> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerMetricsCollectionManager.class);
    private ContainerMetricsRawCollector<RAWDATA> containerMetricsRawCollector;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final LightAgentRegistry lightAgentRegistry;
    private final DockerProcessProperties processProperties;
    private Map<String, ContainerMetrics<RAWDATA>> containerMetricsMap;
    private final DockerContainerMetricsFactory<RAWDATA> dockerContainerMetricsFactory;
    private final TimeSupplier timeSupplier;
    private final MachineProperties serverHostProperties;

    @Inject
    @VisibleForTesting
    ContainerMetricsCollectionManager(ContainerMetricsRawCollector<RAWDATA> containerMetricsRawCollector, SimAgentRepetitiveLogger repetitiveLogger, LightAgentRegistry lightAgentRegistry, @NonNull DockerProcessProperties processProperties, DockerContainerMetricsFactory<RAWDATA> dockerContainerMetricsFactory, TimeSupplier timeSupplier, MachineProperties serverHostProperties) {
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        this.containerMetricsRawCollector = containerMetricsRawCollector;
        this.repetitiveLogger = repetitiveLogger;
        this.lightAgentRegistry = lightAgentRegistry;
        this.processProperties = processProperties;
        this.containerMetricsMap = Collections.emptyMap();
        this.dockerContainerMetricsFactory = dockerContainerMetricsFactory;
        this.timeSupplier = timeSupplier;
        this.serverHostProperties = serverHostProperties;
    }

    public void collectAndReport(Map<String, DockerContainerFull> containerIdToContainerDtoMap, Set<ContainerComponentName> componentNames) {
        Set<String> containerIds = containerIdToContainerDtoMap.keySet();
        this.containerMetricsMap = this.buildContainerMetricsMap(containerIds);
        long startTime = this.timeSupplier.get();
        Map<String, RAWDATA> containersRawData = this.containerMetricsRawCollector.collect(containerIdToContainerDtoMap, componentNames);
        long endTime = this.timeSupplier.get();
        log.trace("Total time in collecting metrics for {} out of {} containers is : {} (ms)", new Object[]{containersRawData.size(), containerIds.size(), endTime - startTime});
        for (String containerId : containerIds) {
            ContainerMetrics<RAWDATA> containerMetrics = this.containerMetricsMap.get(containerId);
            RAWDATA rawdata = containersRawData.get(containerId);
            if (rawdata == null) {
                this.repetitiveLogger.warn(log, "No data collected for container - {}", new Object[]{containerId});
                continue;
            }
            try {
                if (containerMetrics == null) continue;
                this.repetitiveLogger.debug(log, "Updating and reporting metrics for container - {} components {}", new Object[]{containerId, componentNames});
                Set<ContainerComponentName> successfullyUpdated = containerMetrics.update(containersRawData.get(containerId), componentNames, this.serverHostProperties);
                this.repetitiveLogger.debug(log, "{} components successfully updated for container {}", new Object[]{successfullyUpdated, containerId});
                Set<ContainerComponentName> successfullyReported = containerMetrics.report(successfullyUpdated);
                this.repetitiveLogger.debug(log, "{} components successfully reported for container {} ", new Object[]{successfullyReported, containerId});
            }
            catch (RuntimeException exception) {
                this.repetitiveLogger.warn(log, "Error while reporting metrics for container - {} with components - {}", new Object[]{containerId, componentNames});
            }
        }
        try {
            this.processProperties.readyToReport();
        }
        catch (Exception e) {
            log.debug("Exception while reporting processes for containers, {}", (Throwable)e);
            log.error("Couldn't report container processes, {}" + e.getMessage());
        }
    }

    @VisibleForTesting
    public Map<String, ContainerMetrics<RAWDATA>> buildContainerMetricsMap(Set<String> containerIds) {
        ImmutableMap.Builder containerStatsMapBuilder = new ImmutableMap.Builder();
        for (String containerId : containerIds) {
            try {
                ContainerMetrics<RAWDATA> containerMetrics = this.containerMetricsMap.get(containerId);
                if (containerMetrics == null) {
                    Optional lightSystemAgentOptional = this.lightAgentRegistry.getAgent(containerId);
                    if (lightSystemAgentOptional.isPresent()) {
                        MetricsService metricsService = ((LightSystemAgent)this.lightAgentRegistry.getAgent(containerId).get()).getMetricsService();
                        MachineProperties machineProperties = ((LightSystemAgent)this.lightAgentRegistry.getAgent(containerId).get()).getContainerProperties();
                        containerMetrics = this.dockerContainerMetricsFactory.make(metricsService, machineProperties);
                        containerStatsMapBuilder.put((Object)containerId, containerMetrics);
                        continue;
                    }
                    this.repetitiveLogger.warn(log, "LightAgent not found in LightAgentRegistry for container - {}", new Object[]{containerId});
                    continue;
                }
                containerStatsMapBuilder.put((Object)containerId, containerMetrics);
            }
            catch (RuntimeException e) {
                this.repetitiveLogger.warn(log, "Failed to add container - {} to the DockerApiContainerMetrics map.", new Object[]{containerId, e});
            }
        }
        return containerStatsMapBuilder.build();
    }
}

