/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker;

import com.appdynamics.sim.agent.extensions.docker.configuration.ContainerMonitoringConfig;
import com.appdynamics.sim.agent.extensions.docker.configuration.DockerMonitorConfig;
import com.appdynamics.sim.agent.extensions.docker.tags.DockerTagsConfigsDecider;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerMonitorConfigListener
implements ConfigurationListener<DockerMonitorConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerMonitorConfigListener.class);
    private final DockerTagsConfigsDecider dockerTagsConfigsDecider;
    private Optional<DockerMonitorConfig> monitorConfig;

    @Inject
    DockerMonitorConfigListener(DockerTagsConfigsDecider dockerTagsConfigsDecider) {
        this.dockerTagsConfigsDecider = dockerTagsConfigsDecider;
        this.monitorConfig = Optional.absent();
    }

    public void apply(String s, DockerMonitorConfig configuration) {
        boolean changed;
        if (configuration == null) {
            log.warn("Received null Docker Monitor Config.");
            changed = false;
        } else {
            boolean bl = changed = !this.monitorConfig.isPresent() || !((DockerMonitorConfig)this.monitorConfig.get()).equals(configuration);
        }
        if (changed) {
            this.monitorConfig = Optional.of((Object)configuration);
            this.logDockerTagsConfigurationChange(configuration.getContainerMonitoringConfig());
        }
    }

    @VisibleForTesting
    void logDockerTagsConfigurationChange(ContainerMonitoringConfig configuration) {
        if (configuration == null) {
            return;
        }
        if (this.dockerTagsConfigsDecider.isTagEnabled()) {
            log.info("Docker tags is collection is enabled.");
        } else {
            log.info("Docker tags is collection is disabled.");
        }
    }
}

