/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.docker;

import com.appdynamics.agent.sim.docker.model.ContainerPropertiesDto;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerPropertiesRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerPropertiesRegistry.class);
    private final SimAgentRepetitiveLogger simAgentRepetitiveLogger;
    private Map<String, ContainerPropertiesDto> containerPropertiesMap;

    @Inject
    ContainerPropertiesRegistry(SimAgentRepetitiveLogger simAgentRepetitiveLogger) {
        this.simAgentRepetitiveLogger = simAgentRepetitiveLogger;
    }

    void set(Map<String, ContainerPropertiesDto> containerPropertiesMap) {
        this.containerPropertiesMap = containerPropertiesMap;
    }

    public Optional<Long> getContainerPid(String containerId) {
        if (this.containerPropertiesMap == null) {
            return Optional.absent();
        }
        if (this.containerPropertiesMap.containsKey(containerId)) {
            try {
                return Optional.fromNullable((Object)Long.valueOf(this.containerPropertiesMap.get(containerId).getState().getContainerPid()));
            }
            catch (NumberFormatException nfe) {
                this.simAgentRepetitiveLogger.debug(log, "Unable to parse container pid for container Id: {} with error {}", new Object[]{containerId, nfe.getCause()});
            }
        }
        return Optional.absent();
    }
}

