/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.properties.containerdGrpc.model;

import com.appdynamics.agent.sim.docker.model.ContainerPropertiesDto;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.containerd.properties.model.ContainerProperties;
import com.appdynamics.sim.common.biz.shared.machines.SimMachineProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.util.SizeUnit;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerdGrpcContainerProperties
implements ContainerProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdGrpcContainerProperties.class);
    private static final String SHA256 = "sha256:";
    private static final String UNLIMITED = "unlimited";
    private static final String SLASH = "/";
    private static final String CPUS_FORMAT_PATTERN = "#.##";
    private static final double CPU_CPUS_UNLIMITED = 0.0;
    private static final int MEMORY_SWAP_UNLIMITED = -1;
    private ContainerPropertiesDto containerPropertiesDto;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private static final String CONTAINER_ID = "Container|Id";
    private static final String CONTAINER_FULL_ID = "Container|Full Id";
    private static final String PORT_PROTOCOL_SEPARATOR = "/";
    private final DecimalFormat cpusDecimalFormat;
    private final MachineProperties machineProperties;

    @Inject
    public ContainerdGrpcContainerProperties(@Assisted @NonNull MachineProperties machineProperties, SimAgentRepetitiveLogger repetitiveLogger) {
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        this.machineProperties = machineProperties;
        this.repetitiveLogger = repetitiveLogger;
        this.cpusDecimalFormat = new DecimalFormat(CPUS_FORMAT_PATTERN);
    }

    @Override
    public void report() {
        if (this.containerPropertiesDto != null) {
            this.machineProperties.updateProperty(CONTAINER_ID, this.containerPropertiesDto.getContainerId());
            this.machineProperties.updateProperty(CONTAINER_FULL_ID, this.containerPropertiesDto.getContainerId());
            this.machineProperties.updateProperty("Container|Name", this.getContainerName());
            if (this.containerPropertiesDto.getConfig() != null) {
                this.machineProperties.updateProperty("Container|Image|Name", this.containerPropertiesDto.getConfig().getImageName());
                this.machineProperties.updateProperty("Container|Hostname", this.containerPropertiesDto.getConfig().getHostName());
            }
            this.machineProperties.updateProperty("Container|Image|Id", this.getImageId());
            this.machineProperties.updateProperty("Container|Image|Full Id", this.getImageId());
            this.machineProperties.updateProperty("Container|Created At", this.containerPropertiesDto.getCreatedAt());
            if (this.containerPropertiesDto.getState() != null) {
                this.machineProperties.updateProperty("Container|Started At", this.containerPropertiesDto.getState().getStartedAt());
            }
            if (this.containerPropertiesDto.getHostConfig() != null) {
                this.machineProperties.updateProperty("Container|CPU|Share", String.valueOf(this.containerPropertiesDto.getHostConfig().getCpuShares()));
                this.machineProperties.updateProperty("Container|CPU|CPUs", this.calculateCpuLimit());
                this.machineProperties.updateProperty("Container|CPU|Set", this.containerPropertiesDto.getHostConfig().getCpuSet());
                this.machineProperties.updateProperty("Container|Memory|Swap", this.getMemorySwap());
                this.machineProperties.updateProperty("Container|Memory|Reservation (MB)", this.getMemoryReservationMB());
                this.machineProperties.updateProperty("Container|Network|Mode", this.containerPropertiesDto.getHostConfig().getNetworkMode());
            }
            if (this.containerPropertiesDto.getNetworkSettings() != null) {
                this.machineProperties.updateProperty("Container|Network|Ports", this.getPortBindings(this.containerPropertiesDto.getNetworkSettings().getContainerPortToHostPort()));
            }
            this.reportMountProperties();
        } else {
            this.repetitiveLogger.warn(log, "No properties available to be reported", new Object[0]);
        }
    }

    @Override
    public void update(ContainerPropertiesDto containerPropertiesDto) {
        this.containerPropertiesDto = containerPropertiesDto;
    }

    private String getImageId() {
        String imageId = this.containerPropertiesDto.getImageId();
        if (imageId != null) {
            return imageId.replace(SHA256, "");
        }
        return "";
    }

    private String getMemorySwap() {
        long memorySwap = this.containerPropertiesDto.getHostConfig().getMemorySwap();
        if (memorySwap == -1L) {
            return UNLIMITED;
        }
        return String.valueOf(memorySwap);
    }

    @VisibleForTesting
    String getMemoryReservationMB() {
        long memoryReservationInBytes = this.containerPropertiesDto.getHostConfig().getMemoryReservation();
        long memoryLimitInMB = SizeUnit.BYTES.toMegabytes(memoryReservationInBytes);
        return String.valueOf(memoryLimitInMB);
    }

    private String getContainerName() {
        String containerName = this.containerPropertiesDto.getName();
        if (containerName.startsWith("/")) {
            return containerName.substring(1);
        }
        return containerName;
    }

    @VisibleForTesting
    String calculateCpuLimit() {
        double cpuLimit = 0.0;
        long cpuQuota = this.containerPropertiesDto.getHostConfig().getCpuQuota();
        long cpuPeriod = this.containerPropertiesDto.getHostConfig().getCpuPeriod();
        long nanoCpus = this.containerPropertiesDto.getHostConfig().getNanoCpus();
        if (nanoCpus > 0L) {
            cpuLimit = (double)nanoCpus * 1.0E-9;
        } else if (cpuQuota != 0L && cpuPeriod != 0L) {
            cpuLimit = 1.0 * (double)cpuQuota / (double)cpuPeriod;
        }
        return this.cpusDecimalFormat.format(cpuLimit);
    }

    @VisibleForTesting
    String getMountPointFromMount(ContainerPropertiesDto.Mount mount) {
        return mount.getSource();
    }

    @VisibleForTesting
    void reportMountProperties() {
        for (ContainerPropertiesDto.Mount mount : this.containerPropertiesDto.getMounts()) {
            String mountPoint = this.getMountPointFromMount(mount);
            if (mountPoint == null) continue;
            this.machineProperties.updateProperty(SimMachineProperties.format((String)"Volume|{0}|MountPoint", (String)mountPoint), mountPoint);
            if (mount.getName() != null) {
                this.machineProperties.updateProperty(SimMachineProperties.format((String)"Volume|{0}|Name", (String)mountPoint), mount.getName());
            }
            if (mount.getType() != null) {
                this.machineProperties.updateProperty(SimMachineProperties.format((String)"Volume|{0}|Type", (String)mountPoint), mount.getType());
            }
            if (mount.getSource() != null) {
                this.machineProperties.updateProperty(SimMachineProperties.format((String)"Volume|{0}|Source", (String)mountPoint), mount.getSource());
            }
            if (mount.getDestination() == null) continue;
            this.machineProperties.updateProperty(SimMachineProperties.format((String)"Volume|{0}|Destination", (String)mountPoint), mount.getDestination());
        }
    }

    @VisibleForTesting
    String getPortBindings(Map<String, List<ContainerPropertiesDto.HostPort>> containerPortToHostPortMap) {
        ArrayList<CallSite> hostPortAndContainerPorts = new ArrayList<CallSite>();
        if (containerPortToHostPortMap != null && !containerPortToHostPortMap.isEmpty()) {
            for (Map.Entry<String, List<ContainerPropertiesDto.HostPort>> entry : containerPortToHostPortMap.entrySet()) {
                List<ContainerPropertiesDto.HostPort> hostPorts;
                Optional<String> containerPort = this.extractContainerPort(entry.getKey());
                if (!containerPort.isPresent() || (hostPorts = entry.getValue()) == null || hostPorts.isEmpty() || hostPorts.get(0) == null || hostPorts.get(0).getHostPort() == null) continue;
                String hostPortAndContainerPort = hostPorts.get(0).getHostPort() + ":" + (String)containerPort.get();
                hostPortAndContainerPorts.add((CallSite)((Object)hostPortAndContainerPort));
            }
        }
        return Joiner.on((String)",").join(hostPortAndContainerPorts);
    }

    @VisibleForTesting
    Optional<String> extractContainerPort(String portNumberAndProtocol) {
        Optional containerPort = Optional.absent();
        Iterable result = Splitter.on((String)"/").trimResults().omitEmptyStrings().split((CharSequence)portNumberAndProtocol);
        String port = (String)result.iterator().next();
        if (StringUtils.isNumeric((CharSequence)port)) {
            containerPort = Optional.of((Object)port);
        }
        return containerPort;
    }

    @Generated
    public ContainerdGrpcContainerProperties(ContainerPropertiesDto containerPropertiesDto, SimAgentRepetitiveLogger repetitiveLogger, DecimalFormat cpusDecimalFormat, MachineProperties machineProperties) {
        this.containerPropertiesDto = containerPropertiesDto;
        this.repetitiveLogger = repetitiveLogger;
        this.cpusDecimalFormat = cpusDecimalFormat;
        this.machineProperties = machineProperties;
    }
}

