/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model;

import com.appdynamics.agent.sim.containerd.model.ContainerdApiContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model.ContainerdApiContainerNetwork;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerNetwork;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerNetworks;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.NonNull;

public class ContainerdApiContainerNetworks
extends ContainerNetworks<ContainerdApiContainerMetricsRawData> {
    ContainerdApiContainerNetworks(@NonNull MetricsService metricsService, MachineProperties machineProperties) {
        super(metricsService, machineProperties);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
    }

    @Override
    public final void update(ContainerdApiContainerMetricsRawData dockerApiContainerMetricsRawData, MachineProperties serverHostProperties) {
        Set<String> currentIds = this.extractIds(dockerApiContainerMetricsRawData);
        this.components.keySet().retainAll(currentIds);
        for (String id : currentIds) {
            if (this.components.containsKey(id)) continue;
            ContainerdApiContainerNetwork component = new ContainerdApiContainerNetwork(id, this.metricsService);
            this.components.put(id, component);
        }
        for (ContainerNetwork component : this.components.values()) {
            component.update(dockerApiContainerMetricsRawData, serverHostProperties);
        }
    }

    private Set<String> extractIds(ContainerdApiContainerMetricsRawData dockerApiContainerMetricsRawData) {
        LinkedHashSet ids = new LinkedHashSet(dockerApiContainerMetricsRawData.getNetworksInfoMap().keySet());
        return Collections.unmodifiableSet(ids);
    }
}

