/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model;

import com.appdynamics.agent.sim.containerd.model.ContainerdApiContainerMetricsRawData;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DateUtil;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorHandleResetUtil;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorUtil;
import com.appdynamics.sim.agent.extensions.api.util.SizeUnitUtil;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerNetwork;
import com.google.common.base.Optional;
import lombok.NonNull;

public class ContainerdApiContainerNetwork
extends ContainerNetwork<ContainerdApiContainerMetricsRawData> {
    private final DeltaCalculatorHandleResetUtil incomingBytesCalculator;
    private final DeltaCalculatorHandleResetUtil outgoingBytesCalculator;
    private final DeltaCalculatorHandleResetUtil incomingPacketsCalculator;
    private final DeltaCalculatorHandleResetUtil outgoingPacketsCalculator;
    private final DeltaCalculatorHandleResetUtil incomingErrorsCalculator;
    private final DeltaCalculatorHandleResetUtil outgoingErrorsCalculator;
    private final DeltaCalculatorHandleResetUtil incomingDroppedPacketsCalculator;
    private final DeltaCalculatorHandleResetUtil outgoingDroppedPacketsCalculator;
    private final RateCalculatorUtil incomingBytesPerSecCalculator;
    private final RateCalculatorUtil outgoingBytesPerSecCalculator;
    private final DateUtil dateUtil;

    ContainerdApiContainerNetwork(@NonNull String networkName, @NonNull MetricsService metricsService) {
        super(networkName, metricsService);
        if (networkName == null) {
            throw new NullPointerException("networkName is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        this.incomingBytesCalculator = new DeltaCalculatorHandleResetUtil();
        this.outgoingBytesCalculator = new DeltaCalculatorHandleResetUtil();
        this.incomingPacketsCalculator = new DeltaCalculatorHandleResetUtil();
        this.outgoingPacketsCalculator = new DeltaCalculatorHandleResetUtil();
        this.incomingErrorsCalculator = new DeltaCalculatorHandleResetUtil();
        this.outgoingErrorsCalculator = new DeltaCalculatorHandleResetUtil();
        this.incomingDroppedPacketsCalculator = new DeltaCalculatorHandleResetUtil();
        this.outgoingDroppedPacketsCalculator = new DeltaCalculatorHandleResetUtil();
        this.incomingBytesPerSecCalculator = new RateCalculatorUtil();
        this.outgoingBytesPerSecCalculator = new RateCalculatorUtil();
        this.dateUtil = new DateUtil();
    }

    @Override
    public void update(ContainerdApiContainerMetricsRawData dockerApiContainerMetricsRawData, MachineProperties serverHostProperties) {
        ContainerdApiContainerMetricsRawData.NetworkInfo networkInfo = (ContainerdApiContainerMetricsRawData.NetworkInfo)dockerApiContainerMetricsRawData.getNetworksInfoMap().get(this.networkName);
        this.incomingBytesCalculator.calculate(networkInfo.getRxBytes());
        this.outgoingBytesCalculator.calculate(networkInfo.getTxBytes());
        this.incomingPacketsCalculator.calculate(networkInfo.getRxPackets());
        this.outgoingPacketsCalculator.calculate(networkInfo.getTxPackets());
        this.incomingErrorsCalculator.calculate(networkInfo.getRxErrors());
        this.outgoingErrorsCalculator.calculate(networkInfo.getTxErrors());
        this.incomingDroppedPacketsCalculator.calculate(networkInfo.getRxDropped());
        this.outgoingDroppedPacketsCalculator.calculate(networkInfo.getTxDropped());
        long timeStampInSeconds = this.dateUtil.convertRawDateToSeconds(dockerApiContainerMetricsRawData.getTimeStamp());
        this.incomingBytesPerSecCalculator.calculate(networkInfo.getRxBytes(), timeStampInSeconds);
        this.outgoingBytesPerSecCalculator.calculate(networkInfo.getTxBytes(), timeStampInSeconds);
    }

    @Override
    protected Optional<Long> getIncomingKb() {
        return Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)this.incomingBytesCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getOutgoingKb() {
        return Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)this.outgoingBytesCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getIncomingKbPerSec() {
        return Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)this.incomingBytesPerSecCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getOutgoingKbPerSec() {
        return Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)this.outgoingBytesPerSecCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getIncomingPackets() {
        return Optional.of((Object)this.incomingPacketsCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getOutgoingPackets() {
        return Optional.of((Object)this.outgoingPacketsCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getIncomingErrors() {
        return Optional.of((Object)this.incomingErrorsCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getOutgoingErrors() {
        return Optional.of((Object)this.outgoingErrorsCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getIncomingPacketsDropped() {
        return Optional.of((Object)this.incomingDroppedPacketsCalculator.getLastResult());
    }

    @Override
    protected Optional<Long> getOutgoingPacketsDropped() {
        return Optional.of((Object)this.outgoingDroppedPacketsCalculator.getLastResult());
    }
}

