/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.containerd.model.ContainerdApiContainerMetricsRawData;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.containerd.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model.ContainerdApiContainerCpu;
import com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model.ContainerdApiContainerDisk;
import com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model.ContainerdApiContainerMemory;
import com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model.ContainerdApiContainerNetworks;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerComponent;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerMetrics;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.EnumMap;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerdApiContainerMetrics
implements ContainerMetrics<ContainerdApiContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdApiContainerMetrics.class);
    private final EnumMap<ContainerComponentName, ContainerComponent<ContainerdApiContainerMetricsRawData>> containerComponentMap;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    public ContainerdApiContainerMetrics(@Assisted @NonNull MetricsService metricsService, @Assisted @NonNull MachineProperties machineProperties, SimAgentRepetitiveLogger repetitiveLogger, BootstrapConfiguration bootstrapConfiguration) {
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        this.repetitiveLogger = repetitiveLogger;
        this.bootstrapConfiguration = bootstrapConfiguration;
        ContainerdApiContainerNetworks containerdApiContainerNetworks = new ContainerdApiContainerNetworks(metricsService, machineProperties);
        ContainerdApiContainerCpu containerdApiContainerCpu = new ContainerdApiContainerCpu(metricsService, bootstrapConfiguration);
        ContainerdApiContainerMemory containerdApiContainerMemory = new ContainerdApiContainerMemory(metricsService, machineProperties);
        ContainerdApiContainerDisk containerdApiContainerDisk = new ContainerdApiContainerDisk(metricsService);
        this.containerComponentMap = new EnumMap(ContainerComponentName.class);
        this.containerComponentMap.put(ContainerComponentName.CPUS, containerdApiContainerCpu);
        this.containerComponentMap.put(ContainerComponentName.MEMORY, containerdApiContainerMemory);
        this.containerComponentMap.put(ContainerComponentName.DISK, containerdApiContainerDisk);
        this.containerComponentMap.put(ContainerComponentName.NETWORK, containerdApiContainerNetworks);
    }

    @Override
    public void report(Set<ContainerComponentName> componentNames) {
        for (ContainerComponentName componentName : componentNames) {
            ContainerComponent<ContainerdApiContainerMetricsRawData> containerComponent = this.containerComponentMap.get((Object)componentName);
            if (containerComponent != null) {
                containerComponent.report();
                continue;
            }
            this.repetitiveLogger.warn(log, "Component - {} is not supported", new Object[]{componentName});
        }
    }

    @Override
    public void update(ContainerdApiContainerMetricsRawData containerdApiContainerMetricsRawData, Set<ContainerComponentName> componentNames, MachineProperties serverHostProperties) {
        for (ContainerComponentName componentName : componentNames) {
            ContainerComponent<ContainerdApiContainerMetricsRawData> containerComponent = this.containerComponentMap.get((Object)componentName);
            if (containerComponent != null) {
                containerComponent.update(containerdApiContainerMetricsRawData, serverHostProperties);
                continue;
            }
            this.repetitiveLogger.warn(log, "Component - {} is not supported", new Object[]{componentName});
        }
    }

    @Generated
    public ContainerdApiContainerMetrics(EnumMap<ContainerComponentName, ContainerComponent<ContainerdApiContainerMetricsRawData>> containerComponentMap, SimAgentRepetitiveLogger repetitiveLogger, BootstrapConfiguration bootstrapConfiguration) {
        this.containerComponentMap = containerComponentMap;
        this.repetitiveLogger = repetitiveLogger;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }
}

