/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.model;

import com.appdynamics.agent.sim.containerd.model.ContainerdApiContainerMetricsRawData;
import com.appdynamics.agent.sim.docker.model.DockerApiDiskData;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DateUtil;
import com.appdynamics.sim.agent.extensions.api.util.OptionalArithmeticUtil;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorForOptionalUtil;
import com.appdynamics.sim.agent.extensions.api.util.SizeUnitUtil;
import com.appdynamics.sim.agent.extensions.containerd.metrics.model.ContainerDisk;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerdApiContainerDisk
extends ContainerDisk<ContainerdApiContainerMetricsRawData> {
    private static final String READ_STRING = "Read";
    private static final String WRITE_STRING = "Write";
    private static final String TOTAL_STRING = "Total";
    private final RateCalculatorForOptionalUtil diskReadCountPerSecCalculator;
    private final RateCalculatorForOptionalUtil diskWriteCountPerSecCalculator;
    private final RateCalculatorForOptionalUtil diskReadBytesPerSecCalculator;
    private final RateCalculatorForOptionalUtil diskWriteBytesPerSecCalculator;
    private final RateCalculatorForOptionalUtil diskServiceTimeInNanoSecRateCalculator;
    private Optional<Long> diskReadCount;
    private Optional<Long> diskWriteCount;
    private Optional<Long> diskReadBytes;
    private Optional<Long> diskWriteBytes;
    private Optional<Long> diskQueueSize;
    private Optional<Long> diskServiceTimeInNanoSec;
    private final DateUtil dateUtil;
    private ContainerdApiContainerMetricsRawData.BlkIOObject blkIOObject;
    private Map<String, DockerApiDiskData> diskIdToDiskData = new HashMap<String, DockerApiDiskData>();

    ContainerdApiContainerDisk(MetricsService metricsService) {
        super(metricsService);
        this.diskReadCountPerSecCalculator = new RateCalculatorForOptionalUtil();
        this.diskWriteCountPerSecCalculator = new RateCalculatorForOptionalUtil();
        this.diskReadBytesPerSecCalculator = new RateCalculatorForOptionalUtil();
        this.diskWriteBytesPerSecCalculator = new RateCalculatorForOptionalUtil();
        this.diskServiceTimeInNanoSecRateCalculator = new RateCalculatorForOptionalUtil();
        this.dateUtil = new DateUtil();
    }

    @Override
    public void update(ContainerdApiContainerMetricsRawData rawData, MachineProperties serverHostProperties) {
        this.blkIOObject = rawData.getBlkIOObject();
        this.preProcessDiskIO();
        long timeStampInSeconds = this.dateUtil.convertRawDateToSeconds(rawData.getTimeStamp());
        this.diskReadCountPerSecCalculator.calculate(this.diskReadCount, timeStampInSeconds);
        this.diskWriteCountPerSecCalculator.calculate(this.diskWriteCount, timeStampInSeconds);
        this.diskReadBytesPerSecCalculator.calculate(this.diskReadBytes, timeStampInSeconds);
        this.diskWriteBytesPerSecCalculator.calculate(this.diskWriteBytes, timeStampInSeconds);
        this.diskServiceTimeInNanoSecRateCalculator.calculate(this.diskServiceTimeInNanoSec, timeStampInSeconds);
    }

    @Override
    protected Optional<Long> getDiskReadCountPerSec() {
        return this.diskReadCountPerSecCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getDiskWriteCountPerSec() {
        return this.diskWriteCountPerSecCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getDiskReadKbPerSec() {
        Optional readBytesPerSec = this.diskReadBytesPerSecCalculator.getLastResult();
        if (readBytesPerSec.isPresent()) {
            return Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)((Long)readBytesPerSec.get())));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getDiskWriteKbPerSec() {
        Optional writeBytesPerSec = this.diskWriteBytesPerSecCalculator.getLastResult();
        if (writeBytesPerSec.isPresent()) {
            return Optional.of((Object)SizeUnitUtil.convertByteToDecimalKiloByte((long)((Long)writeBytesPerSec.get())));
        }
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getDiskQueueSize() {
        return this.diskQueueSize;
    }

    @Override
    protected Optional<Double> getDiskServiceTimePerSec() {
        Optional diskServiceTimeInNanoSecRate = this.diskServiceTimeInNanoSecRateCalculator.getLastResult();
        if (diskServiceTimeInNanoSecRate.isPresent()) {
            return Optional.of((Object)(1.0 * (double)((Long)diskServiceTimeInNanoSecRate.get()).longValue() * 1.0E-9));
        }
        return Optional.absent();
    }

    @VisibleForTesting
    void preProcessDiskIO() {
        this.diskReadCount = Optional.absent();
        this.diskWriteCount = Optional.absent();
        this.diskReadBytes = Optional.absent();
        this.diskWriteBytes = Optional.absent();
        this.diskQueueSize = Optional.absent();
        this.diskServiceTimeInNanoSec = Optional.absent();
        this.transformDiskData();
        for (Map.Entry<String, DockerApiDiskData> entries : this.diskIdToDiskData.entrySet()) {
            DockerApiDiskData diskData = entries.getValue();
            this.diskReadCount = OptionalArithmeticUtil.addOptionalLongValues(this.diskReadCount, (Optional)diskData.getReadCount());
            this.diskWriteCount = OptionalArithmeticUtil.addOptionalLongValues(this.diskWriteCount, (Optional)diskData.getWriteCount());
            this.diskReadBytes = OptionalArithmeticUtil.addOptionalLongValues(this.diskReadBytes, (Optional)diskData.getReadBytes());
            this.diskWriteBytes = OptionalArithmeticUtil.addOptionalLongValues(this.diskWriteBytes, (Optional)diskData.getWriteBytes());
            this.diskQueueSize = OptionalArithmeticUtil.addOptionalLongValues(this.diskQueueSize, (Optional)diskData.getQueueSize());
            this.diskServiceTimeInNanoSec = OptionalArithmeticUtil.addOptionalLongValues(this.diskServiceTimeInNanoSec, (Optional)diskData.getServiceTime());
        }
    }

    @VisibleForTesting
    void transformDiskData() {
        DockerApiDiskData diskData;
        String diskId;
        this.diskIdToDiskData.clear();
        List diskInfoCount = this.blkIOObject.getCountInfo();
        List diskInfoBytes = this.blkIOObject.getBytesInfo();
        List diskInfoQueue = this.blkIOObject.getQueueInfo();
        List diskInfoServiceTime = this.blkIOObject.getServiceTimeInfo();
        if (diskInfoCount != null) {
            for (ContainerdApiContainerMetricsRawData.DiskInfo diskInfo : diskInfoCount) {
                diskId = this.getDiskId(diskInfo);
                diskData = this.getDiskDataById(diskId);
                if (diskInfo.getOp().equals(READ_STRING)) {
                    diskData.setReadCount(Optional.of((Object)diskInfo.getValue()));
                    continue;
                }
                if (!diskInfo.getOp().equals(WRITE_STRING)) continue;
                diskData.setWriteCount(Optional.of((Object)diskInfo.getValue()));
            }
        }
        if (diskInfoBytes != null) {
            for (ContainerdApiContainerMetricsRawData.DiskInfo diskInfo : diskInfoBytes) {
                diskId = this.getDiskId(diskInfo);
                diskData = this.getDiskDataById(diskId);
                if (diskInfo.getOp().equals(READ_STRING)) {
                    diskData.setReadBytes(Optional.of((Object)diskInfo.getValue()));
                    continue;
                }
                if (!diskInfo.getOp().equals(WRITE_STRING)) continue;
                diskData.setWriteBytes(Optional.of((Object)diskInfo.getValue()));
            }
        }
        if (diskInfoQueue != null) {
            for (ContainerdApiContainerMetricsRawData.DiskInfo diskInfo : diskInfoQueue) {
                diskId = this.getDiskId(diskInfo);
                diskData = this.getDiskDataById(diskId);
                if (!diskInfo.getOp().equals(TOTAL_STRING)) continue;
                diskData.setQueueSize(Optional.of((Object)diskInfo.getValue()));
            }
        }
        if (diskInfoServiceTime != null) {
            for (ContainerdApiContainerMetricsRawData.DiskInfo diskInfo : diskInfoServiceTime) {
                diskId = this.getDiskId(diskInfo);
                diskData = this.getDiskDataById(diskId);
                if (!diskInfo.getOp().equals(TOTAL_STRING)) continue;
                diskData.setServiceTime(Optional.of((Object)diskInfo.getValue()));
            }
        }
    }

    @VisibleForTesting
    DockerApiDiskData getDiskDataById(String diskId) {
        if (!this.diskIdToDiskData.containsKey(diskId)) {
            this.diskIdToDiskData.put(diskId, new DockerApiDiskData());
        }
        return this.diskIdToDiskData.get(diskId);
    }

    @VisibleForTesting
    String getDiskId(ContainerdApiContainerMetricsRawData.DiskInfo diskInfo) {
        return String.valueOf(diskInfo.getMajor()) + ":" + diskInfo.getMinor();
    }
}

