/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.collector;

import com.appdynamics.agent.sim.containerd.ContainerdService;
import com.appdynamics.agent.sim.containerd.model.ContainerdApiContainerMetricsRawData;
import com.appdynamics.agent.sim.containerd.model.ContainerdContainerDto;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.containerd.ContainerdMonitoring;
import com.appdynamics.sim.agent.extensions.containerd.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.containerd.metrics.collector.ContainerMetricsRawCollector;
import com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.collector.ContainerdApiMetricCollectionCallable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerdApiMetricsRawCollector
implements ContainerMetricsRawCollector<ContainerdApiContainerMetricsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdApiMetricsRawCollector.class);
    private final ExecutorService executorService;
    private final ContainerdService containerdService;
    private final SimAgentRepetitiveLogger repetitiveLogger;

    @Inject
    ContainerdApiMetricsRawCollector(@ContainerdMonitoring ExecutorService executorService, ContainerdService containerdService, SimAgentRepetitiveLogger repetitiveLogger) {
        this.executorService = executorService;
        this.containerdService = containerdService;
        this.repetitiveLogger = repetitiveLogger;
    }

    @Override
    public Map<String, ContainerdApiContainerMetricsRawData> collect(List<ContainerdContainerDto> containers, Set<ContainerComponentName> componentNames) {
        log.debug("Collecting Containerd Statistics for containers - {} and components - {}", containers, componentNames);
        if (containers.isEmpty() || componentNames.isEmpty()) {
            return Maps.newHashMap();
        }
        ArrayList<ContainerdApiMetricCollectionCallable> metricCollectorTasks = new ArrayList<ContainerdApiMetricCollectionCallable>(containers.size());
        ImmutableMap.Builder idToContainerMetricsBuilder = ImmutableMap.builder();
        for (ContainerdContainerDto containerdContainerDto : containers) {
            metricCollectorTasks.add(new ContainerdApiMetricCollectionCallable(containerdContainerDto, this.containerdService));
        }
        try {
            List containerIdToContainerStatsFutures = this.executorService.invokeAll(metricCollectorTasks);
            for (Future future : containerIdToContainerStatsFutures) {
                try {
                    Map containerMetrics = (Map)future.get();
                    idToContainerMetricsBuilder.putAll(containerMetrics);
                }
                catch (ExecutionException e) {
                    this.repetitiveLogger.warn(log, "Skip retrieving data for a container due to: ", new Object[]{e.getCause()});
                }
            }
        }
        catch (InterruptedException e) {
            log.warn("Containerd Monitor Metric Collection is interrupted.");
            Thread.currentThread().interrupt();
        }
        ImmutableMap idToStats = idToContainerMetricsBuilder.build();
        return idToStats;
    }
}

