/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.collector;

import com.appdynamics.agent.sim.containerd.ContainerdService;
import com.appdynamics.agent.sim.containerd.model.ContainerdApiContainerMetricsRawData;
import com.appdynamics.agent.sim.containerd.model.ContainerdContainerDto;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContainerdApiMetricCollectionCallable
implements Callable<Map<String, ContainerdApiContainerMetricsRawData>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdApiMetricCollectionCallable.class);
    private final ContainerdContainerDto container;
    private final ContainerdService containerdService;

    public ContainerdApiMetricCollectionCallable(ContainerdContainerDto container, ContainerdService containerdService) {
        this.container = container;
        this.containerdService = containerdService;
    }

    @Override
    public Map<String, ContainerdApiContainerMetricsRawData> call() throws Exception {
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        try {
            ContainerdApiContainerMetricsRawData containerMetricsRawData = this.containerdService.getContainerMetricsRawData(this.container);
            resultBuilder.put((Object)this.container.getId(), (Object)containerMetricsRawData);
            log.trace("Successfully retrieved container metrics for containerId {} - {}", (Object)this.container.getId(), (Object)containerMetricsRawData);
        }
        catch (Exception e) {
            log.error("Failed collection metric for containerId: {} with error: {}", (Object)this.container.getId(), (Object)e);
        }
        return resultBuilder.build();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerdApiMetricCollectionCallable)) {
            return false;
        }
        ContainerdApiMetricCollectionCallable other = (ContainerdApiMetricCollectionCallable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContainerdContainerDto this$container = this.container;
        ContainerdContainerDto other$container = other.container;
        if (this$container == null ? other$container != null : !this$container.equals(other$container)) {
            return false;
        }
        ContainerdService this$containerdService = this.containerdService;
        ContainerdService other$containerdService = other.containerdService;
        return !(this$containerdService == null ? other$containerdService != null : !this$containerdService.equals(other$containerdService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContainerdApiMetricCollectionCallable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContainerdContainerDto $container = this.container;
        result = result * 59 + ($container == null ? 43 : $container.hashCode());
        ContainerdService $containerdService = this.containerdService;
        result = result * 59 + ($containerdService == null ? 43 : $containerdService.hashCode());
        return result;
    }
}

