/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd;

import com.appdynamics.sim.agent.extensions.containerd.ContainerdMonitor;
import com.appdynamics.sim.agent.extensions.containerd.ContainerdMonitoring;
import com.appdynamics.sim.agent.extensions.containerd.ContainerdRegistrationTaskFactory;
import com.appdynamics.sim.agent.extensions.containerd.metrics.containerdApi.ContainerdApiMetricsCollectorModule;
import com.appdynamics.sim.agent.extensions.containerd.properties.ContainerdContainerPropertiesFactory;
import com.appdynamics.sim.agent.extensions.containerd.properties.containerdGrpc.model.ContainerdGrpcContainerProperties;
import com.appdynamics.sim.agent.extensions.containerd.properties.model.ContainerProperties;
import com.appdynamics.voltron.extensions.api.ExtensionModule;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionModule
public class ContainerdMonitoringModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdMonitoringModule.class);
    private final String CONTAINERD_METRIC_COLLECTOR_THREAD_NAME = "Containerd-Metric-Collector-%d";

    protected void configure() {
        this.bind(ContainerdMonitor.class).asEagerSingleton();
        this.install(new FactoryModuleBuilder().build(ContainerdRegistrationTaskFactory.class));
        this.install(new FactoryModuleBuilder().implement(ContainerProperties.class, ContainerdGrpcContainerProperties.class).build(ContainerdContainerPropertiesFactory.class));
        this.install((Module)new ContainerdApiMetricsCollectorModule());
    }

    @Provides
    @Singleton
    @ContainerdMonitoring
    ExecutorService providesDockerMonitoringExecutorService() {
        Integer poolSize = 3;
        log.info("Initializing Executor Service for Containerd Metric Collection, pool size:  {}", (Object)poolSize);
        ThreadFactory collectorThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Containerd-Metric-Collector-%d").build();
        return Executors.newFixedThreadPool(poolSize, collectorThreadFactory);
    }
}

