/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.containerd.ContainerdService;
import com.appdynamics.agent.sim.containerd.ContainerdUtils;
import com.appdynamics.agent.sim.containerd.model.ContainerdContainerDto;
import com.appdynamics.agent.sim.containerd.model.ContainerdContainerFull;
import com.appdynamics.agent.sim.lightagent.LightAgentRegistry;
import com.appdynamics.agent.sim.lightagent.LightSystemAgent;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.agent.sim.main.MachineAgentEnabledFeatures;
import com.appdynamics.agent.sim.metadata.MachineMetadata;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.containerd.ContainerHostMapper;
import com.appdynamics.sim.agent.extensions.containerd.ContainerdCollector;
import com.appdynamics.sim.agent.extensions.containerd.ContainerdMonitoring;
import com.appdynamics.sim.agent.extensions.containerd.ContainerdRegistrationTask;
import com.appdynamics.sim.agent.extensions.containerd.ContainerdRegistrationTaskFactory;
import com.appdynamics.sim.agent.extensions.containerd.metrics.ContainerMetricsCollectionManager;
import com.appdynamics.sim.agent.extensions.containerd.metrics.collector.ContainerComponentName;
import com.appdynamics.sim.agent.extensions.containerd.properties.ContainerdContainerPropertiesFactory;
import com.appdynamics.sim.agent.extensions.containerd.properties.model.ContainerProperties;
import com.appdynamics.sim.common.biz.shared.docker.AgentMetadataDockerRequest;
import com.appdynamics.sim.common.biz.shared.docker.ContainerMappingInfo;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContainerdMonitor
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdMonitor.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final long REGISTRATION_TIMEOUT_IN_SECONDS = 60L;
    private static final boolean HISTORICAL = true;
    private final Scheduler scheduler;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private volatile ScheduledFuture<?> future;
    private volatile long scheduledInterval;
    private final String serverHostId;
    private final TimeSupplier timeSupplier;
    private final LightAgentRegistry lightAgentRegistry;
    private final ContainerdRegistrationTaskFactory registrationTaskFactory;
    private final ExecutorService containerdMonitoringExecutorService;
    private final MachineMetadata machineMetadata;
    private final ContainerdCollector containerdCollector;
    private Map<String, ContainerProperties> containerPropertiesMap;
    private final ContainerdContainerPropertiesFactory containerdContainerPropertiesFactory;
    private final ContainerdService containerdService;
    private final ContainerMetricsCollectionManager<?> containerMetricsCollectionManager;
    private final MachineAgentEnabledFeatures machineAgentEnabledFeatures;
    private final ContainerHostMapper containerHostMapper;
    private Map<String, ContainerdContainerFull> currentContainerIdVsContainer;
    private static final Set<ContainerComponentName> ALL_COMPONENTS = ImmutableSet.of((Object)((Object)ContainerComponentName.CPUS), (Object)((Object)ContainerComponentName.MEMORY));
    private volatile boolean iblSupported;

    @Inject
    ContainerdMonitor(Scheduler scheduler, BootstrapConfiguration bootstrapConfiguration, SimAgentRepetitiveLogger repetitiveLogger, @HostId String serverHostId, TimeSupplier timeSupplier, LightAgentRegistry lightAgentRegistry, ContainerdRegistrationTaskFactory registrationTaskFactory, @ContainerdMonitoring ExecutorService executorService, MachineMetadata machineMetadata, ContainerdCollector containerdCollector, ContainerdContainerPropertiesFactory containerdContainerPropertiesFactory, ContainerdService containerdService, ContainerMetricsCollectionManager<?> containerMetricsCollectionManager, MachineAgentEnabledFeatures machineAgentEnabledFeatures, ContainerHostMapper containerHostMapper) {
        this.scheduler = scheduler;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.repetitiveLogger = repetitiveLogger;
        this.containerHostMapper = containerHostMapper;
        this.serverHostId = serverHostId;
        this.timeSupplier = timeSupplier;
        this.lightAgentRegistry = lightAgentRegistry;
        this.registrationTaskFactory = registrationTaskFactory;
        this.containerdMonitoringExecutorService = executorService;
        this.machineMetadata = machineMetadata;
        this.containerdCollector = containerdCollector;
        this.containerPropertiesMap = Collections.emptyMap();
        this.containerdService = containerdService;
        this.containerdContainerPropertiesFactory = containerdContainerPropertiesFactory;
        this.containerMetricsCollectionManager = containerMetricsCollectionManager;
        this.machineAgentEnabledFeatures = machineAgentEnabledFeatures;
        this.currentContainerIdVsContainer = Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void startMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            boolean dockerEnabled = this.bootstrapConfiguration.getDockerEnabled();
            boolean containerdEnabled = this.bootstrapConfiguration.getContainerdEnabled();
            boolean simEnabled = this.bootstrapConfiguration.getSimUserEnabled();
            if (this.isContainerdMonitoringSupportedOnCurrentOS()) {
                if (this.future == null) {
                    if (dockerEnabled && containerdEnabled) {
                        log.info("Not starting containerd monitoring extension because both docker and containerd are enabled");
                        return;
                    }
                    this.scheduledInterval = 30000L;
                    this.iblSupported = this.isIblSupported();
                    if (this.iblSupported || containerdEnabled && simEnabled) {
                        log.info("Containerd Enabled! Starting containerd monitoring extension");
                        this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, this.scheduledInterval, TimeUnit.MILLISECONDS);
                    } else {
                        log.info("Not starting containerd monitoring extension");
                        log.info("Containerd Enabled: {}; SIM Enabled: {}; IBL supported: {}", new Object[]{containerdEnabled, simEnabled, this.iblSupported});
                    }
                }
            } else {
                log.info("Containerd monitoring is not supported on current OS: {}. Running Machine Agent with Containerd disabled", (Object)SystemUtils.OS_NAME);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stopMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                log.debug("Canceling Containerd Monitoring");
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    @Override
    public void run() {
        try {
            List containers;
            long start = this.timeSupplier.get();
            try {
                containers = this.containerdService.getContainers();
            }
            catch (Exception e) {
                log.error("Error while collecting containerd containersContainers won't be reported to the controller; Error: " + String.valueOf(e));
                throw new RuntimeException(e);
            }
            if (this.bootstrapConfiguration.getSimUserEnabled().booleanValue() && this.bootstrapConfiguration.getContainerdEnabled().booleanValue()) {
                log.debug("Running SIM containerd monitoring");
                this.runSimContainerdMonitoring(containers);
            }
            if (this.getLastIblSupportedValue()) {
                log.debug("Running MA Plus containerd monitoring");
                this.runMaPlusDockerMonitoring(containers);
            }
            if (this.isMonitorRestartRequired()) {
                this.stopMonitor();
                this.startMonitor();
            }
            long end = this.timeSupplier.get();
            log.debug("#Total time to execute Containerd Monitoring: {} ms", (Object)(end - start));
        }
        catch (Exception e) {
            log.error("Error running the containerd monitoring: " + e.getMessage());
        }
    }

    public void runSimContainerdMonitoring(List<ContainerdContainerDto> containers) {
        Map<String, ContainerdContainerFull> containerIdToContainerMap = this.containerdCollector.collect(containers, this.containerdService);
        this.checkForDuplicateHostIds(containerIdToContainerMap);
        Set nonApmContainers = this.lightAgentRegistry.getNonApmContainersToBeMarkedHistorical();
        containerIdToContainerMap = this.removeKeys(containerIdToContainerMap, nonApmContainers);
        Set<String> containerIds = containerIdToContainerMap.keySet();
        log.debug("Registering containerd containers");
        this.registerContainers(containerIdToContainerMap);
        HashSet<String> containersToRemove = new HashSet<String>();
        containersToRemove.addAll(this.lightAgentRegistry.getNonRunningContainers(containerIds));
        containersToRemove.addAll(nonApmContainers);
        if (!containersToRemove.isEmpty()) {
            this.markContainersHistorical(containersToRemove);
            this.lightAgentRegistry.removeNonRunningContainers(containersToRemove);
            this.containerPropertiesMap = this.removeKeys(this.containerPropertiesMap, containersToRemove);
        }
        this.containerPropertiesMap = this.buildContainerPropertiesMap(containerIds);
        this.currentContainerIdVsContainer = containerIdToContainerMap;
        AgentMetadataDockerRequest agentMetadataDockerRequest = this.buildAgentMetadataDockerRequest(containerIdToContainerMap);
        this.machineMetadata.updateMetadata("_agentMetadataDocker", (Object)agentMetadataDockerRequest);
        log.debug("Reporting Containerd Containers.");
        this.containerdCollector.reportProperties(this.containerPropertiesMap);
        log.debug("Reporting Containerd Containers metrics data");
        LinkedList<ContainerdContainerDto> collectAndReportContainers = new LinkedList<ContainerdContainerDto>();
        Set lightAgentRunningContainerIds = this.lightAgentRegistry.getAllRunningContainerIds();
        for (ContainerdContainerDto container : containers) {
            if (!lightAgentRunningContainerIds.contains(container.getId())) continue;
            collectAndReportContainers.add(container);
        }
        this.containerMetricsCollectionManager.collectAndReport(collectAndReportContainers, ALL_COMPONENTS);
    }

    @VisibleForTesting
    void runMaPlusDockerMonitoring(List<ContainerdContainerDto> containers) {
        this.containerHostMapper.updateContainerHostMappings(containers);
    }

    @VisibleForTesting
    void markContainersHistorical(Set<String> nonRunningContainerIds) {
        ArrayList<ContainerdRegistrationTask> containerdRegistrationTasks = new ArrayList<ContainerdRegistrationTask>(nonRunningContainerIds.size());
        for (String containerId : nonRunningContainerIds) {
            try {
                containerdRegistrationTasks.add(this.registrationTaskFactory.create(this.currentContainerIdVsContainer.get(containerId), true));
            }
            catch (RuntimeException e) {
                String message = MessageFormat.format("Error while creating registration task to mark container id {0} historical. {1}", containerId, e.getMessage());
                this.printWarnMessage(message);
            }
        }
        this.submitContainerRegistrations(containerdRegistrationTasks);
    }

    void checkForDuplicateHostIds(Map<String, ContainerdContainerFull> containerIdToContainer) {
        Map<String, String> containerIdToHostId = containerIdToContainer.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ContainerdContainerFull)e.getValue()).getHostId()));
        Set<Map.Entry> duplicateContainerdContainerDtosByHostId = containerIdToContainer.values().stream().collect(Collectors.groupingBy(e -> e.getHostId())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toSet());
        if (!duplicateContainerdContainerDtosByHostId.isEmpty()) {
            duplicateContainerdContainerDtosByHostId.forEach(e -> this.repetitiveLogger.warn(log, "Host Id {} is used by container Ids {}", new Object[]{e.getKey(), ((List)e.getValue()).stream().map(v -> v.getId()).collect(Collectors.toSet())}));
        }
        if (containerIdToHostId.values().contains(this.serverHostId)) {
            Set containerIdsMatchingHostServerHostId = containerIdToHostId.entrySet().stream().filter(e -> ((String)e.getValue()).equals(this.serverHostId)).map(Map.Entry::getKey).collect(Collectors.toSet());
            this.repetitiveLogger.warn(log, "Container Ids: {} are using the host Id: {} that is same as host server's host Id", new Object[]{containerIdsMatchingHostServerHostId, this.serverHostId});
        }
    }

    void registerContainers(Map<String, ContainerdContainerFull> containerIdVsContainer) {
        long startTime = this.timeSupplier.get();
        ArrayList<ContainerdRegistrationTask> containerdRegistrationTasks = new ArrayList<ContainerdRegistrationTask>(containerIdVsContainer.size());
        for (String containerId : containerIdVsContainer.keySet()) {
            try {
                ContainerdContainerFull containerdContainerFull = containerIdVsContainer.get(containerId);
                Optional lightSystemAgentOpt = this.lightAgentRegistry.getAgent(containerId);
                if (lightSystemAgentOpt.isPresent() && !this.isContainerRegistrationDue((LightSystemAgent)lightSystemAgentOpt.get())) continue;
                ContainerdRegistrationTask containerdRegistrationTask = this.registrationTaskFactory.create(containerdContainerFull, false);
                log.debug("Creating registration task for container " + containerdContainerFull.getId());
                containerdRegistrationTasks.add(containerdRegistrationTask);
            }
            catch (RuntimeException re) {
                this.repetitiveLogger.warn(log, "Error creating registration task for container: {} ", new Object[]{containerId});
            }
        }
        this.submitContainerRegistrations(containerdRegistrationTasks);
        long endTime = this.timeSupplier.get();
        log.debug("#Total time for Container Registration: {} ms.", (Object)(endTime - startTime));
    }

    boolean isContainerRegistrationDue(LightSystemAgent lightSystemAgent) {
        long now = this.timeSupplier.get();
        long diffTimeInMilliSeconds = now - lightSystemAgent.getLastRegisteredTime();
        long roundedDiffTimeInSeconds = Math.round(1.0 * (double)diffTimeInMilliSeconds / 1000.0);
        return roundedDiffTimeInSeconds >= 120L;
    }

    void submitContainerRegistrations(List<ContainerdRegistrationTask> registrationTasks) {
        try {
            List containerdRegistrationFutures = this.containerdMonitoringExecutorService.invokeAll(registrationTasks);
            for (Future containerdRegistrationFuture : containerdRegistrationFutures) {
                try {
                    containerdRegistrationFuture.get(60L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    log.warn("Unable to retrieve containerd registration result with cause: {}", (Object)e.getMessage());
                }
                catch (TimeoutException e) {
                    log.warn("A container registration timed out: {}", (Object)e.getMessage());
                }
            }
        }
        catch (InterruptedException e) {
            log.warn("Containerd Container Registration is interrupted");
            Thread.currentThread().interrupt();
        }
    }

    private AgentMetadataDockerRequest buildAgentMetadataDockerRequest(Map<String, ContainerdContainerFull> containerIdToContainerMap) {
        ImmutableSet.Builder containerMappingInfoBuilder = ImmutableSet.builder();
        for (String containerId : this.lightAgentRegistry.getAllRunningContainerIds()) {
            ContainerdContainerFull containerdContainerFull = containerIdToContainerMap.get(containerId);
            Optional lightSystemAgentOptional = this.lightAgentRegistry.getAgent(containerId);
            if (lightSystemAgentOptional.isPresent()) {
                long containerSimMachineId = ((LightSystemAgent)lightSystemAgentOptional.get()).getSimMachineId();
                ContainerMappingInfo containerMappingInfo = ContainerMappingInfo.builder().containerId(containerdContainerFull.getId()).simMachineId(containerSimMachineId).hostName(containerdContainerFull.getHostId()).build();
                containerMappingInfoBuilder.add((Object)containerMappingInfo);
                continue;
            }
            this.repetitiveLogger.warn(log, "Failed to add container - {} to metadata, LightAgent not found in LightAgentRegistry.", new Object[]{containerId});
        }
        return new AgentMetadataDockerRequest((Set)containerMappingInfoBuilder.build());
    }

    Map<String, ContainerProperties> buildContainerPropertiesMap(Set<String> containerIds) {
        ImmutableMap.Builder containerPropertiesMapBuilder = new ImmutableMap.Builder();
        for (String containerId : containerIds) {
            try {
                ContainerProperties containerProperties = this.containerPropertiesMap.get(containerId);
                if (containerProperties == null) {
                    Optional lightSystemAgentOptional = this.lightAgentRegistry.getAgent(containerId);
                    if (lightSystemAgentOptional.isPresent()) {
                        MachineProperties machineProperties = ((LightSystemAgent)this.lightAgentRegistry.getAgent(containerId).get()).getContainerProperties();
                        containerProperties = this.containerdContainerPropertiesFactory.make(machineProperties);
                        containerPropertiesMapBuilder.put((Object)containerId, (Object)containerProperties);
                        continue;
                    }
                    this.repetitiveLogger.debug(log, "LightAgent not found in LightAgentRegistry for container - {}", new Object[]{containerId});
                    continue;
                }
                containerPropertiesMapBuilder.put((Object)containerId, (Object)containerProperties);
            }
            catch (RuntimeException e) {
                this.repetitiveLogger.warn(log, "Failed to add container - {} to the containerPropertiesMap map.", new Object[]{containerId, e});
            }
        }
        return containerPropertiesMapBuilder.build();
    }

    @VisibleForTesting
    boolean isIblSupported() {
        boolean iblStatusCheck = this.isIblEnabled();
        log.debug("IBL feature available: {}", (Object)iblStatusCheck);
        return iblStatusCheck &= this.checkContainerdAccessibility();
    }

    @VisibleForTesting
    boolean isIblEnabled() {
        boolean result = this.machineAgentEnabledFeatures.hasFeature("ibl");
        log.trace("IBL feature enabled: {}", (Object)result);
        return result;
    }

    boolean checkContainerdAccessibility() {
        boolean containerdAccessible = false;
        try {
            List namespaces = this.containerdService.getNamespaces();
            if (namespaces != null && !namespaces.isEmpty()) {
                containerdAccessible = true;
                log.debug("Containerd Info is available, available namespaces: {}", (Object)namespaces);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.debug("Containerd Info is not available");
        }
        return containerdAccessible;
    }

    @VisibleForTesting
    protected boolean isMonitorRestartRequired() {
        boolean IblSupportChanged = this.iblSupported != this.isIblSupported();
        log.debug("IBL support Changed: {}", (Object)IblSupportChanged);
        return IblSupportChanged;
    }

    @VisibleForTesting
    boolean getLastIblSupportedValue() {
        log.trace("Last result of MA plus eligibility: {}", (Object)this.iblSupported);
        return this.iblSupported;
    }

    @VisibleForTesting
    boolean isContainerdMonitoringSupportedOnCurrentOS() {
        return ContainerdUtils.isContainerdMonitoringSupportedOnCurrentOS();
    }

    private <T> Map<String, T> removeKeys(Map<String, T> map, Set<String> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : map.keySet()) {
            if (keys.contains(key)) continue;
            builder.put((Object)key, map.get(key));
        }
        return builder.build();
    }

    @VisibleForTesting
    void printWarnMessage(String message) {
        log.warn(message);
    }
}

