/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd;

import com.appdynamics.agent.sim.containerd.ContainerdService;
import com.appdynamics.agent.sim.containerd.ContainerdUtils;
import com.appdynamics.agent.sim.containerd.model.ContainerTaskPropertiesDto;
import com.appdynamics.agent.sim.containerd.model.ContainerdContainerDto;
import com.appdynamics.agent.sim.containerd.model.ContainerdContainerFull;
import com.appdynamics.agent.sim.docker.model.ContainerPropertiesDto;
import com.appdynamics.agent.sim.docker.model.ImagePropertiesDto;
import com.appdynamics.agent.sim.k8s.K8sContainerTags;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.containerd.properties.model.ContainerProperties;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerdCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerdCollector.class);
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private Map<String, ContainerPropertiesDto> containerPropertiesRawDataMap;
    private Map<String, Optional<ImagePropertiesDto>> containerImageRawDataMap;
    private final TimeSupplier timeSupplier;
    private final K8sContainerTags k8sContainerTags;
    private final String NAMESPACE_KEY = "container-namespace";

    @Inject
    ContainerdCollector(SimAgentRepetitiveLogger repetitiveLogger, TimeSupplier timeSupplier, K8sContainerTags k8sContainerTags) {
        this.repetitiveLogger = repetitiveLogger;
        this.containerPropertiesRawDataMap = Collections.emptyMap();
        this.timeSupplier = timeSupplier;
        this.k8sContainerTags = k8sContainerTags;
    }

    public Map<String, ContainerdContainerFull> collect(List<ContainerdContainerDto> containers, ContainerdService containerdService) {
        long startTime = this.timeSupplier.get();
        LinkedHashSet<String> containerIds = new LinkedHashSet<String>();
        for (ContainerdContainerDto container : containers) {
            containerIds.add(container.getId());
        }
        this.containerPropertiesRawDataMap = this.collectContainerProperties(containerIds, containerdService);
        this.containerImageRawDataMap = this.collectContainerImages(containerIds, containerdService);
        Map<String, ContainerdContainerFull> containerIdToContainerMap = this.buildContainerdContainerDtos(containerIds);
        log.debug("{} containers being monitored: {}", (Object)containerIds.size(), containerIds);
        long endTime = this.timeSupplier.get();
        log.trace("#Total time for Containerd Metric Collection: {} ms", (Object)(endTime - startTime));
        return containerIdToContainerMap;
    }

    public void reportProperties(@NonNull Map<String, ContainerProperties> containerPropertiesMap) {
        if (containerPropertiesMap == null) {
            throw new NullPointerException("containerPropertiesMap is marked non-null but is null");
        }
        Set<String> containerIds = containerPropertiesMap.keySet();
        for (String containerId : containerIds) {
            ContainerProperties containerProperties = containerPropertiesMap.get(containerId);
            try {
                ContainerPropertiesDto containerPropertiesDto = this.containerPropertiesRawDataMap.get(containerId);
                if (containerPropertiesDto == null) {
                    log.debug("Could not get ContainerPropertiesDto for the container {}. So skipping update and reportProperties.", (Object)containerId);
                    continue;
                }
                containerProperties.update(containerPropertiesDto);
                containerProperties.report();
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Exception while trying to update and reportProperties container metrics for the container {} ", new Object[]{containerId, e});
            }
        }
    }

    Map<String, ContainerPropertiesDto> collectContainerProperties(Set<String> containerIds, ContainerdService containerdService) {
        ImmutableMap.Builder containerPropertiesDtoMap = new ImmutableMap.Builder();
        try {
            List namespaces = containerdService.getNamespaces();
            LinkedHashMap containerProperties = new LinkedHashMap();
            for (String namespace : namespaces) {
                Map taskProperties = containerdService.getTaskProperties(namespace);
                containerProperties.putAll(taskProperties);
            }
            for (String containerId : containerIds) {
                ContainerPropertiesDto containerPropertiesDto = this.getContainerPropertiesDto(containerId, (ContainerTaskPropertiesDto)containerProperties.get(containerId));
                log.debug("Container properties for container \"" + containerId + "\" [containerPropertiesDto]: " + String.valueOf(containerPropertiesDto));
                containerPropertiesDtoMap.put((Object)containerId, (Object)containerPropertiesDto);
            }
        }
        catch (Exception e) {
            log.error("Error occurred while collecting container properties!  " + String.valueOf(e));
        }
        return containerPropertiesDtoMap.build();
    }

    private ContainerPropertiesDto getContainerPropertiesDto(String containerId, ContainerTaskPropertiesDto properties) {
        ContainerPropertiesDto containerPropertiesDto = new ContainerPropertiesDto();
        String createdAt = properties.getCreatedAt();
        String imageName = properties.getImage();
        Map labels = properties.getLabels();
        labels.put("container-namespace", properties.getNamespace());
        ContainerPropertiesDto containerPropertiesDto2 = ContainerPropertiesDto.builder().containerId(containerId).name(containerId).hostConfig(null).config(new ContainerPropertiesDto.Config(imageName, this.getEffectiveHostName(containerId), labels)).createdAt(createdAt).imageId(this.extractImageId(imageName)).state(new ContainerPropertiesDto.State(createdAt, "0")).mounts(new ArrayList()).networkSettings(new ContainerPropertiesDto.NetworkSettings(new LinkedHashMap())).build();
        return containerPropertiesDto2;
    }

    String extractImageId(String image) {
        String[] parts = image.split("/");
        return parts[parts.length - 1];
    }

    Map<String, Optional<ImagePropertiesDto>> collectContainerImages(Set<String> containerIds, ContainerdService containerdService) {
        ImmutableMap.Builder containerImageDtoMap = new ImmutableMap.Builder();
        for (String containerId : containerIds) {
            Optional<ContainerPropertiesDto> propertiesDtoOptional = this.getContainerProperties(containerId);
            if (!propertiesDtoOptional.isPresent()) continue;
            String imageName = ((ContainerPropertiesDto)propertiesDtoOptional.get()).getConfig().getImageName();
            containerImageDtoMap.put((Object)containerId, (Object)Optional.absent());
        }
        return containerImageDtoMap.build();
    }

    Optional<ContainerPropertiesDto> getContainerProperties(String containerId) {
        return Optional.fromNullable((Object)this.containerPropertiesRawDataMap.get(containerId));
    }

    private Map<String, ContainerdContainerFull> buildContainerdContainerDtos(Set<String> containerIds) {
        ImmutableMap.Builder containers = ImmutableMap.builder();
        for (String containerId : containerIds) {
            try {
                ContainerPropertiesDto containerPropertiesDto = this.containerPropertiesRawDataMap.get(containerId);
                Optional<ImagePropertiesDto> imagePropertiesDto = this.containerImageRawDataMap.get(containerId);
                Map containerTags = this.k8sContainerTags.getTagsByContainerId(containerId);
                ContainerPropertiesDto.Config config = containerPropertiesDto.getConfig();
                String hostId = this.getEffectiveHostId(containerPropertiesDto, containerId);
                ContainerdContainerFull containerdContainerFull = new ContainerdContainerFull(containerId, config.getHostName(), hostId, containerPropertiesDto, imagePropertiesDto, containerTags);
                containers.put((Object)containerId, (Object)containerdContainerFull);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Exception while trying to build container Dto {} ", new Object[]{containerId, e});
            }
        }
        return containers.build();
    }

    private String getEffectiveHostId(ContainerPropertiesDto containerPropertiesDto, String containerId) {
        return containerId;
    }

    @VisibleForTesting
    String getEffectiveHostName(String containerId) {
        try {
            String hostname1 = ContainerdUtils.getHostname1();
            log.debug("Hostname of container \"" + containerId + "\" set to " + hostname1);
            return hostname1;
        }
        catch (UnknownHostException e) {
            log.debug("Error fetching hostname details for " + containerId);
            try {
                String hostname1 = ContainerdUtils.getHostname2();
                log.debug("Hostname of container \"" + containerId + "\" set to " + hostname1);
                return hostname1;
            }
            catch (IOException | InterruptedException e2) {
                log.debug("Error fetching hostname details for " + containerId);
                return containerId;
            }
        }
    }
}

