/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.containerd;

import com.appdynamics.agent.sim.containerd.ContainerdUtils;
import com.appdynamics.agent.sim.containerd.model.ContainerdContainerDto;
import com.appdynamics.agent.sim.dmm.SimMachineIdSupplier;
import com.appdynamics.agent.sim.metadata.MachineMetadata;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.common.biz.shared.docker.AgentMetadataContainerMappingRequest;
import com.appdynamics.sim.common.biz.shared.docker.MetadataContainerMappingInfo;
import com.appdynamics.voltron.utils.TimeSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerHostMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContainerHostMapper.class);
    public static final long CONTAINERS_FOR_REGISTRATION_EXPIRATION_TIMEOUT_MILLIS = 150000L;
    private final MachineMetadata machineMetadata;
    private final SimMachineIdSupplier simHostMachineIdSupplier;
    private final TimeSupplier timeSupplier;
    private final String hostServerHostId;
    private Set<String> containersRegistry;
    private Cache<String, String> containersToBeRegistered;
    private volatile long lastResetEpochMilli;
    private volatile long maxFailureCount;
    private volatile long currentFailureCount;

    @Inject
    public ContainerHostMapper(MachineMetadata machineMetadata, SimMachineIdSupplier simHostMachineIdSupplier, TimeSupplier timeSupplier, @HostId String hostServerHostId) {
        this.machineMetadata = machineMetadata;
        this.simHostMachineIdSupplier = simHostMachineIdSupplier;
        this.timeSupplier = timeSupplier;
        this.hostServerHostId = hostServerHostId;
        this.init(timeSupplier, 150000L);
    }

    public void updateContainerHostMappings(List<ContainerdContainerDto> containerDtos) {
        Optional simHostMachineIdOpt = this.simHostMachineIdSupplier.get();
        if (simHostMachineIdOpt.isPresent()) {
            log.debug("Sim Host Machine Id is present. Continue with gathering of containers");
            if (containerDtos == null || containerDtos.isEmpty()) {
                return;
            }
            Set<String> containers = containerDtos.stream().map(ContainerdContainerDto::getId).collect(Collectors.toSet());
            if (this.getContainersRegistry().isEmpty()) {
                log.debug("Container registry is empty");
                this.addContainersForRegistration(containers);
                this.addContainersIntoRegistry(containers);
            } else {
                log.debug("Calculating delta for containers to registered");
                Set<String> newContainers = this.getNewContainersToBeRegistered(containers);
                this.addContainersForRegistration(newContainers);
                this.addContainersIntoRegistry(newContainers);
            }
            this.updateMachineMetadata();
            this.resetFailureCount();
        } else {
            if (this.getCurrentFailureCount() >= 0L) {
                this.incrementFailureCount();
            }
            log.debug("Sim Host Machine Id is absent. New value for failure count: {}", (Object)this.getCurrentFailureCount());
        }
        this.resetRegistryIfRequired();
    }

    @VisibleForTesting
    protected void init(TimeSupplier timeSupplier, long expireAfterWriteMillis) {
        this.currentFailureCount = -1L;
        this.containersRegistry = ConcurrentHashMap.newKeySet();
        this.containersToBeRegistered = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMillis(expireAfterWriteMillis)).build();
        this.lastResetEpochMilli = timeSupplier.get();
        this.maxFailureCount = this.calculateMaxFailureCount();
    }

    @VisibleForTesting
    protected long calculateMaxFailureCount() {
        long containerdSamplingInterval = 30000L;
        long maxFailureLimit = 300000L;
        long result = maxFailureLimit / containerdSamplingInterval + 1L;
        log.debug("Max Failure Limit: {}; Containerd Sampling Interval: {}; Max Failure Count: {}", new Object[]{maxFailureLimit, containerdSamplingInterval, result});
        return result;
    }

    @VisibleForTesting
    protected void addContainersForRegistration(Set<String> containers) {
        log.debug("Containers to be added for registration: {}", containers);
        this.containersToBeRegistered.putAll(containers.stream().collect(Collectors.toMap(c -> c, c -> c)));
    }

    @VisibleForTesting
    protected void addContainersIntoRegistry(Set<String> containers) {
        log.debug("Containers to be added into registry: {}", containers);
        this.containersRegistry.addAll(containers);
    }

    @VisibleForTesting
    protected Set<String> getNewContainersToBeRegistered(Set<String> containers) {
        log.debug("Getting new containers to be added for registration");
        log.trace("Current containers: {}", this.getContainersRegistry());
        log.trace("New containers: {}", containers);
        Sets.SetView newContainers = Sets.difference(containers, this.getContainersRegistry());
        log.trace("Delta: {}", (Object)newContainers);
        return newContainers;
    }

    @VisibleForTesting
    protected void updateMachineMetadata() {
        log.debug("Updating machine metadata with container mappings");
        AgentMetadataContainerMappingRequest agentMetadataContainerMappingRequest = this.buildAgentMetadataContainerMappingRequest();
        this.machineMetadata.updateMetadata("_agentMetadataContainerMapping", (Object)agentMetadataContainerMappingRequest);
    }

    @VisibleForTesting
    protected AgentMetadataContainerMappingRequest buildAgentMetadataContainerMappingRequest() {
        log.debug("Building agent metadata container mapping request");
        ImmutableSet.Builder containerMappingBuilder = ImmutableSet.builder();
        for (String container : this.getContainersToBeRegistered().asMap().keySet()) {
            String containerHostName = this.getEffectiveHostName(container);
            log.debug("Container is about to be added. Id: {}; Host Name: {}", (Object)container, (Object)containerHostName);
            MetadataContainerMappingInfo containerMappingInfo = new MetadataContainerMappingInfo(container, containerHostName);
            containerMappingBuilder.add((Object)containerMappingInfo);
        }
        AgentMetadataContainerMappingRequest result = new AgentMetadataContainerMappingRequest(this.hostServerHostId, (Set)containerMappingBuilder.build());
        log.debug("Agent metadata container mapping request: {}", (Object)result);
        return result;
    }

    @VisibleForTesting
    protected void resetRegistryIfRequired() {
        if (this.checkIfRegistryResetRequired()) {
            this.resetRegistry();
        }
    }

    @VisibleForTesting
    protected boolean checkIfRegistryResetRequired() {
        log.debug("Checking if registry reset is required. Current failure count: {}; Max Failure Count: {}; Last Reset Epoch Millis: {}", new Object[]{this.getCurrentFailureCount(), this.getMaxFailureCount(), this.getLastResetEpochMilli()});
        if (this.getCurrentFailureCount() < 0L || this.getCurrentFailureCount() >= this.getMaxFailureCount()) {
            return true;
        }
        long now = this.timeSupplier.get();
        return now - this.getLastResetEpochMilli() > this.getResetInterval();
    }

    @VisibleForTesting
    protected void resetRegistry() {
        log.debug("Resetting registry");
        long now = this.timeSupplier.get();
        this.containersRegistry.clear();
        this.containersToBeRegistered.invalidateAll();
        this.lastResetEpochMilli = now;
        log.debug("New value of Last Reset Epoch Millis: {}", (Object)this.lastResetEpochMilli);
    }

    @VisibleForTesting
    protected long getResetInterval() {
        long resetInterval = 86400000L;
        log.debug("Reset Interval: {}", (Object)resetInterval);
        return resetInterval;
    }

    @VisibleForTesting
    protected void resetFailureCount() {
        log.debug("Resetting failure count");
        this.currentFailureCount = 0L;
    }

    @VisibleForTesting
    protected void incrementFailureCount() {
        log.debug("Incrementing failure count");
        ++this.currentFailureCount;
    }

    @VisibleForTesting
    protected Set<String> getContainersRegistry() {
        return this.containersRegistry;
    }

    @VisibleForTesting
    protected Cache<String, String> getContainersToBeRegistered() {
        return this.containersToBeRegistered;
    }

    @VisibleForTesting
    protected long getLastResetEpochMilli() {
        return this.lastResetEpochMilli;
    }

    @VisibleForTesting
    protected long getMaxFailureCount() {
        return this.maxFailureCount;
    }

    @VisibleForTesting
    protected long getCurrentFailureCount() {
        return this.currentFailureCount;
    }

    @VisibleForTesting
    String getEffectiveHostName(String containerId) {
        try {
            String hostname1 = ContainerdUtils.getHostname1();
            log.debug("Hostname of container \"" + containerId + "\" set to " + hostname1);
            return hostname1;
        }
        catch (UnknownHostException e) {
            log.debug("Error fetching hostname details for " + containerId);
            try {
                String hostname1 = ContainerdUtils.getHostname2();
                log.debug("Hostname of container \"" + containerId + "\" set to " + hostname1);
                return hostname1;
            }
            catch (IOException | InterruptedException e2) {
                log.debug("Error fetching hostname details for " + containerId);
                return containerId;
            }
        }
    }
}

