/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache.exception;

public class CacheServiceException
extends Exception {
    private final Type errorType;

    public CacheServiceException(Type errorType, String message) {
        super(message);
        this.errorType = errorType;
    }

    public CacheServiceException(Type errorType, String message, Exception cause) {
        super(message, cause);
        this.errorType = errorType;
    }

    public Type getErrorType() {
        return this.errorType;
    }

    public boolean isServiceDown() {
        return Type.SERVICE_NOT_FOUND.equals((Object)this.errorType);
    }

    public boolean isWritingToSlave() {
        return Type.SERVICE_NOT_WRITABLE.equals((Object)this.errorType);
    }

    public boolean isServiceNotReachable() {
        return Type.SERVICE_NOT_FOUND == this.errorType || Type.SERVICE_MOVED == this.errorType || Type.SERVICE_NOT_WRITABLE == this.errorType || Type.CIRCUIT_BREAKER_OPEN == this.errorType;
    }

    public static enum Type {
        SERVER_ERROR,
        SERVICE_NOT_FOUND,
        SERVICE_MOVED,
        ILLEGAL_OPERATION,
        FAILED_OPERATION,
        DATA_PARSE_ERROR,
        SERVICE_NOT_WRITABLE,
        CIRCUIT_BREAKER_OPEN,
        TIME_OUT;

    }
}

