/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import com.appdynamics.platform.services.cache.CacheObjectKey;
import com.appdynamics.platform.services.cache.CacheObjectKeyBucket;
import com.appdynamics.platform.services.cache.CacheSerializer;
import com.appdynamics.platform.services.cache.exception.SerializerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;

public class StoreAdapter<K, V> {
    protected static final Logger logger = Logger.getLogger(StoreAdapter.class.getName());
    @NotNull
    private final CacheObjectKeyBucket bucket;
    private final CacheSerializer<K, V> serializer;

    public StoreAdapter(@NotNull CacheObjectKeyBucket cacheObjectKeyBucket, CacheSerializer<K, V> serializer) {
        logger.info("ID000070: Constructing StoreAdapter using cacheObjectKeyBucket " + cacheObjectKeyBucket);
        this.bucket = cacheObjectKeyBucket;
        this.serializer = serializer;
    }

    public CacheObjectKeyBucket getCacheObjectKeyBucket() {
        return this.bucket;
    }

    public CacheSerializer<K, V> getCacheSerializer() {
        return this.serializer;
    }

    public CacheObjectKey makeMainKey(K key) {
        if (key instanceof String) {
            return this.bucket.get((String)key);
        }
        if (key instanceof Long) {
            return this.bucket.get((Long)key);
        }
        return this.bucket.get(key.hashCode());
    }

    public byte[] serializeKey(K key) throws SerializerException {
        return this.serializer.serializeKey(key);
    }

    public List<byte[]> serializeKeys(Collection<K> keys) throws SerializerException {
        ArrayList<byte[]> ret = new ArrayList<byte[]>(keys.size());
        for (K key : keys) {
            ret.add(this.serializeKey(key));
        }
        return ret;
    }

    public byte[] serializeValue(V value) throws SerializerException {
        return this.serializer.serializeValue(value);
    }

    public List<byte[]> serializeValues(Collection<V> values) throws SerializerException {
        ArrayList<byte[]> ret = new ArrayList<byte[]>(values.size());
        for (V value : values) {
            ret.add(this.serializeValue(value));
        }
        return ret;
    }

    public V deSerializeValue(byte[] bytes) throws SerializerException {
        return this.serializer.deSerializeValue(bytes);
    }
}

