/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface Stats {
    public String getCacheRegionName();

    public long size();

    public long hits();

    public long misses();

    public long reads();

    public long writes();

    public long failures();

    public long writesTime();

    public long evictions();

    default public Stats diff(final Stats previousStats) {
        return new Stats(){

            @Override
            public String getCacheRegionName() {
                return Stats.this.getCacheRegionName();
            }

            @Override
            public long size() {
                return Stats.this.size();
            }

            @Override
            public long hits() {
                return Stats.this.hits() - previousStats.hits();
            }

            @Override
            public long misses() {
                return Stats.this.misses() - previousStats.misses();
            }

            @Override
            public long reads() {
                return Stats.this.reads() - previousStats.reads();
            }

            @Override
            public long writes() {
                return Stats.this.writes() - previousStats.writes();
            }

            @Override
            public long failures() {
                return Stats.this.failures() - previousStats.writesTime();
            }

            @Override
            public long writesTime() {
                return Stats.this.writesTime() - previousStats.writesTime();
            }

            @Override
            public long evictions() {
                return Stats.this.evictions() - previousStats.evictions();
            }
        };
    }

    default public Map<String, Long> collectStats(String metricTemplatePrefix) {
        HashMap<String, Long> metrics = new HashMap<String, Long>();
        String metricTemplate = metricTemplatePrefix + "|%s|%s";
        metrics.put(String.format(metricTemplate, this.getCacheRegionName(), "Hits"), this.hits());
        metrics.put(String.format(metricTemplate, this.getCacheRegionName(), "Misses"), this.misses());
        metrics.put(String.format(metricTemplate, this.getCacheRegionName(), "Size"), this.size());
        metrics.put(String.format(metricTemplate, this.getCacheRegionName(), "Reads"), this.reads());
        metrics.put(String.format(metricTemplate, this.getCacheRegionName(), "Writes"), this.writes());
        metrics.put(String.format(metricTemplate, this.getCacheRegionName(), "Failures"), this.failures());
        metrics.put(String.format(metricTemplate, this.getCacheRegionName(), "Writes time"), this.writesTime());
        metrics.put(String.format(metricTemplate, this.getCacheRegionName(), "Evictions"), this.evictions());
        return Collections.unmodifiableMap(metrics);
    }
}

