/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public class MemoryEfficientLongSet
implements Serializable {
    private final TLongHashSet longSet;
    private final TIntHashSet intSet;

    private MemoryEfficientLongSet(int initialSize) {
        this.longSet = new TLongHashSet(initialSize);
        this.intSet = new TIntHashSet(initialSize);
    }

    public static MemoryEfficientLongSet of(int initialSize) {
        return new MemoryEfficientLongSet(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long value) {
        boolean ret;
        boolean useIntSet = MemoryEfficientLongSet.useIntSet(value);
        TLongHashSet tLongHashSet = this.longSet;
        synchronized (tLongHashSet) {
            ret = useIntSet ? this.intSet.add((int)value) : this.longSet.add(value);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long value) {
        boolean ret;
        boolean useIntSet = MemoryEfficientLongSet.useIntSet(value);
        TLongHashSet tLongHashSet = this.longSet;
        synchronized (tLongHashSet) {
            ret = useIntSet ? this.intSet.remove((int)value) : this.longSet.remove(value);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long value) {
        boolean ret;
        boolean useIntSet = MemoryEfficientLongSet.useIntSet(value);
        TLongHashSet tLongHashSet = this.longSet;
        synchronized (tLongHashSet) {
            ret = useIntSet ? this.intSet.contains((int)value) : this.longSet.contains(value);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        TLongHashSet tLongHashSet = this.longSet;
        synchronized (tLongHashSet) {
            this.longSet.clear();
            this.intSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean ret;
        TLongHashSet tLongHashSet = this.longSet;
        synchronized (tLongHashSet) {
            ret = this.longSet.isEmpty() && this.intSet.isEmpty();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int ret;
        TLongHashSet tLongHashSet = this.longSet;
        synchronized (tLongHashSet) {
            ret = this.longSet.size() + this.intSet.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<Long> coll) {
        HashSet<Integer> ints = new HashSet<Integer>(coll.size());
        HashSet<Long> longs = new HashSet<Long>(coll.size());
        for (Long value : coll) {
            if (MemoryEfficientLongSet.useIntSet(value)) {
                ints.add(value.intValue());
                continue;
            }
            longs.add(value);
        }
        TLongHashSet tLongHashSet = this.longSet;
        synchronized (tLongHashSet) {
            this.longSet.addAll(longs);
            this.intSet.addAll(ints);
        }
    }

    private static boolean useIntSet(long value) {
        return value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE;
    }

    public String toString() {
        return "MELS{size =" + this.size() + "}";
    }
}

