/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import com.appdynamics.platform.services.cache.Stats;
import com.google.common.cache.CacheStats;
import java.util.Objects;

public class LoadingCacheStats
implements Stats {
    static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
    private final CacheStats cacheStats;
    private final long size;
    private final String name;

    public LoadingCacheStats(CacheStats stats, long size, String name) {
        this.cacheStats = Objects.requireNonNull(stats);
        this.size = size;
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public String getCacheRegionName() {
        return this.name;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long hits() {
        return this.cacheStats.hitCount();
    }

    @Override
    public long misses() {
        return this.cacheStats.missCount();
    }

    @Override
    public long reads() {
        return this.cacheStats.requestCount();
    }

    @Override
    public long writes() {
        return this.cacheStats.loadCount();
    }

    @Override
    public long failures() {
        return this.cacheStats.loadExceptionCount();
    }

    @Override
    public long writesTime() {
        return this.cacheStats.totalLoadTime();
    }

    @Override
    public long evictions() {
        return this.cacheStats.evictionCount();
    }
}

