/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public abstract class ImmutableOptimizedSet {
    public static <T> Set<T> of(T value) {
        return Collections.singleton(value);
    }

    public static <T> Set<T> of(T value1, T value2) {
        HashSet set = new HashSet(2);
        Collections.addAll(set, value1, value2);
        return ImmutableOptimizedSet.of(set);
    }

    public static <T> Set<T> of(T value1, T value2, T value3) {
        HashSet set = new HashSet(3);
        Collections.addAll(set, value1, value2, value3);
        return ImmutableOptimizedSet.of(set);
    }

    public static <T> Set<T> of(T value1, T value2, T value3, T value4) {
        HashSet set = new HashSet(4);
        Collections.addAll(set, value1, value2, value3, value4);
        return ImmutableOptimizedSet.of(set);
    }

    public static <T> Set<T> of(Set<T> setOfValues) {
        Set<Object> ret;
        int size = setOfValues.size();
        if (size == 0) {
            ret = Collections.emptySet();
        } else if (size == 1) {
            ret = Collections.singleton(setOfValues.iterator().next());
        } else if (size > 4) {
            ret = Collections.unmodifiableSet(new HashSet<T>(setOfValues));
        } else {
            Object[] values = setOfValues.toArray();
            ret = size == 2 ? new SetOf2<Object>(values[0], values[1]) : (size == 3 ? new SetOf3<Object>(values[0], values[1], values[2]) : (size == 4 ? new SetOf4<Object>(values[0], values[1], values[2], values[3]) : Collections.unmodifiableSet(new HashSet<T>(setOfValues))));
        }
        return ret;
    }

    private static class SetOf4<T>
    extends SetOf3<T> {
        protected final T value4;

        SetOf4(T v1, T v2, T v3, T v4) {
            super(v1, v2, v3);
            this.value4 = v4;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public boolean contains(Object obj) {
            return Objects.equals(this.value4, obj) || super.contains(obj);
        }

        @Override
        public Iterator<T> iterator() {
            return new ImmutableOptimizedSetIterator(this);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.value1, this.value2, this.value3, this.value4};
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            T1[] ret = super.toArray(a);
            ret[3] = this.value4;
            return ret;
        }

        @Override
        public T getAt(int pos) {
            if (pos == 3) {
                return this.value4;
            }
            return super.getAt(pos);
        }
    }

    private static class SetOf3<T>
    extends SetOf2<T> {
        protected final T value3;

        SetOf3(T v1, T v2, T v3) {
            super(v1, v2);
            this.value3 = v3;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public boolean contains(Object obj) {
            return Objects.equals(this.value3, obj) || super.contains(obj);
        }

        @Override
        public Iterator<T> iterator() {
            return new ImmutableOptimizedSetIterator(this);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.value1, this.value2, this.value3};
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            T1[] ret = super.toArray(a);
            ret[2] = this.value3;
            return ret;
        }

        @Override
        public T getAt(int pos) {
            if (pos == 2) {
                return this.value3;
            }
            return super.getAt(pos);
        }
    }

    private static class SetOf2<T>
    extends AbstractImmutableOptimizedSet<T> {
        protected final T value1;
        protected final T value2;

        SetOf2(T v1, T v2) {
            this.value1 = v1;
            this.value2 = v2;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean contains(Object obj) {
            return Objects.equals(this.value1, obj) || Objects.equals(this.value2, obj);
        }

        @Override
        public Iterator<T> iterator() {
            return new ImmutableOptimizedSetIterator(this);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.value1, this.value2};
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            Object[] ret = a.length >= this.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            ret[0] = this.value1;
            ret[1] = this.value2;
            return ret;
        }

        @Override
        public T getAt(int pos) {
            if (pos == 0) {
                return this.value1;
            }
            if (pos == 1) {
                return this.value2;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static class ImmutableOptimizedSetIterator<T>
    implements Iterator<T> {
        protected int pos = 0;
        protected AbstractImmutableOptimizedSet<T> set;

        ImmutableOptimizedSetIterator(AbstractImmutableOptimizedSet<T> set) {
            this.set = set;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.set.size();
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T ret = this.set.getAt(this.pos);
                ++this.pos;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static abstract class AbstractImmutableOptimizedSet<T>
    implements Set<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private AbstractImmutableOptimizedSet() {
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object obj : c) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            Set c = (Set)obj;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Object obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        public abstract T getAt(int var1);
    }
}

