/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import com.appdynamics.platform.services.cache.ByteParser;
import com.appdynamics.platform.services.cache.CacheSerializer;
import com.appdynamics.platform.services.cache.StructuredKeyFactory;
import com.appdynamics.platform.services.cache.exception.SerializerException;
import com.google.protobuf.MessageLite;
import java.nio.charset.StandardCharsets;

public class DefaultSerializer<K, V>
implements CacheSerializer<K, V> {
    private final StructuredKeyFactory<K> structuredKeyFactory;
    private final ByteParser<V> parser;
    private final Class<V> valueType;

    public DefaultSerializer(StructuredKeyFactory<K> structuredKeyFactory, ByteParser<V> parser, Class<V> valueType) {
        this.structuredKeyFactory = structuredKeyFactory;
        this.parser = parser;
        this.valueType = valueType;
    }

    public DefaultSerializer(ByteParser<V> parser, Class<V> valueType) {
        this(null, parser, valueType);
    }

    public DefaultSerializer(Class<V> valueType) {
        this(null, null, valueType);
    }

    public DefaultSerializer(StructuredKeyFactory<K> structuredKeyFactory, Class<V> valueClass) {
        this(structuredKeyFactory, null, valueClass);
    }

    @Override
    public byte[] serializeKey(K key) throws SerializerException {
        if (this.structuredKeyFactory != null) {
            return this.structuredKeyFactory.serialize(key);
        }
        if (key instanceof byte[]) {
            return (byte[])key;
        }
        if (DefaultSerializer.isSupportedPrimitive(key.getClass())) {
            return key.toString().getBytes(StandardCharsets.UTF_8);
        }
        throw new SerializerException("unknown key type " + key.getClass().getSimpleName());
    }

    @Override
    public byte[] serializeValue(V value) throws SerializerException {
        byte[] ret;
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (DefaultSerializer.isSupportedPrimitive(value.getClass())) {
            return value.toString().getBytes(StandardCharsets.UTF_8);
        }
        if (this.parser != null && (ret = this.parser.toBytes(value)) != null) {
            return ret;
        }
        if (value instanceof MessageLite) {
            return ((MessageLite)value).toByteArray();
        }
        throw new SerializerException("unknown value type :" + value.getClass());
    }

    @Override
    public V deSerializeValue(byte[] bytes) throws SerializerException {
        if (bytes == null) {
            return null;
        }
        if (DefaultSerializer.isSupportedPrimitive(this.valueType)) {
            String string = new String(bytes, StandardCharsets.UTF_8);
            if (this.valueType == String.class) {
                return (V)string;
            }
            if (this.valueType == Integer.class) {
                return (V)Integer.valueOf(Integer.parseInt(string));
            }
            if (this.valueType == Long.class) {
                return (V)Long.valueOf(Long.parseLong(string));
            }
        }
        if (this.valueType == byte[].class) {
            return (V)bytes;
        }
        if (this.parser != null) {
            V ret = this.parser.parseFrom(bytes);
            return ret;
        }
        throw new SerializerException("unknown type");
    }

    private static boolean isSupportedPrimitive(Class<?> classType) {
        return classType == String.class || classType == Integer.class || classType == Long.class;
    }
}

