/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.platform.services.cache;

import com.appdynamics.platform.services.cache.CacheKey;
import com.appdynamics.platform.services.cache.CacheKeyUtil;
import com.appdynamics.platform.services.cache.CacheKeyspace;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public final class CacheObjectKey
implements CacheKey {
    private final String id;
    private volatile byte[] cacheKey;
    private KeyBucketInvariant bucketInfo;

    private CacheObjectKey(KeyBucketInvariant bucketInfo, String id) {
        this.id = id;
        this.bucketInfo = bucketInfo;
    }

    public long getTtlInMillies() {
        if (this.bucketInfo.ttlInSeconds <= 0) {
            return -1L;
        }
        return (long)this.bucketInfo.ttlInSeconds * 1000L;
    }

    public int getTtlInSeconds() {
        if (this.bucketInfo.ttlInSeconds <= 0) {
            return -1;
        }
        return this.bucketInfo.ttlInSeconds;
    }

    public boolean hasTtl() {
        return this.bucketInfo.ttlInSeconds > 0;
    }

    public static CacheObjectKey newInstance(@NotNull KeyBucketInvariant bucketInfo, String id) {
        return new CacheObjectKey(bucketInfo, id);
    }

    public static CacheObjectKey newInstance(@NotNull CacheKeyspace keyspace, @NotNull String family, @NotNull String version, String id) {
        KeyBucketInvariant bucketInfo = new KeyBucketInvariant(keyspace, null, family, version, -1);
        return new CacheObjectKey(bucketInfo, id);
    }

    public String getPartition() {
        return this.bucketInfo.partition;
    }

    public CacheKeyspace getKeyspace() {
        return this.bucketInfo.keyspace;
    }

    public String getFamily() {
        return this.bucketInfo.family;
    }

    public String getVersion() {
        return this.bucketInfo.version;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public byte[] keyAsBytes() {
        if (this.cacheKey == null) {
            this.cacheKey = CacheKeyUtil.getCacheKeyBytes(this);
        }
        return this.cacheKey;
    }

    public String getCacheFamilyKey() {
        return CacheKeyUtil.getCacheFamilyKey(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getPartition(), this.getKeyspace(), this.getFamily(), this.getVersion(), this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CacheObjectKey other = (CacheObjectKey)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.getFamily(), other.getFamily()) && this.getKeyspace() == other.getKeyspace() && Objects.equals(this.getPartition(), other.getPartition()) && Objects.equals(this.getVersion(), other.getVersion());
    }

    public String toString() {
        return CacheKeyUtil.getCacheKey(this);
    }

    public static class Builder {
        private final String family;
        private String id;
        private CacheKeyspace keyspace;
        private String partition;
        private String version;
        private int ttlInSeconds = -1;

        private Builder(@NotNull CacheKeyspace keyspace, @NotNull String family, String version) {
            this.keyspace = keyspace;
            this.family = family;
            this.version = version;
        }

        public Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder ttlInSeconds(int ttl) {
            this.ttlInSeconds = ttl;
            return this;
        }

        public CacheObjectKey build() {
            KeyBucketInvariant bucketInfo = new KeyBucketInvariant(this.keyspace, this.partition, this.family, this.version, this.ttlInSeconds);
            return new CacheObjectKey(bucketInfo, this.id);
        }

        public static Builder newInstance(@NotNull CacheKeyspace keyspace, @NotNull String family, String version) {
            return new Builder(keyspace, family, version);
        }
    }

    static class KeyBucketInvariant {
        final String family;
        final CacheKeyspace keyspace;
        final String partition;
        final String version;
        final int ttlInSeconds;

        KeyBucketInvariant(CacheKeyspace keyspace, String partition, String family, String version, int ttl) {
            this.family = family;
            this.keyspace = keyspace;
            this.partition = partition;
            this.version = version;
            this.ttlInSeconds = ttl;
        }

        public String toString() {
            return "KeyBucketInvariant{family='" + this.family + '\'' + ", version=" + this.version + ", keyspace=" + (Object)((Object)this.keyspace) + ", partition='" + this.partition + '\'' + ", ttlInSeconds=" + this.ttlInSeconds + '}';
        }
    }
}

