/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.io.tcp;

import com.appdynamics.common.io.server.Server;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.configuration.CommonReader;
import com.appdynamics.common.util.exception.Exceptions;
import com.google.common.net.HostAndPort;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServer<H extends ChannelInitializer<SocketChannel>>
extends Server {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TcpServer.class);
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ChannelFuture channelFuture;

    public TcpServer(Parameters<H> parameters) {
        super(parameters.getId());
        log.info("Starting [{}]", parameters);
        NioEventLoopGroup bossGroup = null;
        NioEventLoopGroup workerGroup = null;
        ChannelFuture channelFuture = null;
        try {
            bossGroup = new NioEventLoopGroup(parameters.getNumBossThreads(), ConcurrencyHelper.newDaemonThreadFactory((String)(parameters.getId() + "-boss-%d")));
            workerGroup = new NioEventLoopGroup(parameters.getNumWorkerThreads(), ConcurrencyHelper.newDaemonThreadFactory((String)(parameters.getId() + "-worker-%d")));
            ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
            for (Map.Entry<ChannelOption<Object>, Object> entry : parameters.getChannelOptions().entrySet()) {
                bootstrap.option(entry.getKey(), entry.getValue());
            }
            ((ServerBootstrap)bootstrap.handler((ChannelHandler)new LoggingHandler(parameters.getLogLevel()))).childHandler(parameters.getHandler());
            String host = parameters.getHostAndPort().getHost();
            int port = parameters.getHostAndPort().getPort();
            channelFuture = bootstrap.bind(host, port);
            try {
                channelFuture.sync();
            }
            catch (InterruptedException e) {
                throw Exceptions.rethrowAsRuntimeException((InterruptedException)e);
            }
        }
        catch (Throwable t) {
            if (bossGroup != null) {
                bossGroup.shutdownGracefully();
            }
            if (workerGroup != null) {
                workerGroup.shutdownGracefully();
            }
            throw t;
        }
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.channelFuture = channelFuture;
        log.info("Started [{}]", parameters);
    }

    public void close() {
        log.info("Stopping [{}]", (Object)this.getId());
        try {
            this.channelFuture.channel().close().sync();
        }
        catch (InterruptedException e) {
            log.warn("Thread was interrupted while waiting for channel close", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        log.info("Stopped [{}]", (Object)this.getId());
    }

    public static class Parameters<H extends ChannelInitializer<SocketChannel>> {
        @NotNull
        private String id;
        @NotNull
        private HostAndPort hostAndPort;
        @Min(value=1L)
        private @Min(value=1L) int numBossThreads;
        @Min(value=1L)
        private @Min(value=1L) int numWorkerThreads;
        @NotNull
        private Map<ChannelOption<Object>, Object> channelOptions;
        @NotNull
        private H handler;
        @NotNull
        private LogLevel logLevel;

        public Parameters<H> setId(String id) {
            this.id = id;
            return this;
        }

        public Parameters<H> setHostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        public Parameters<H> setNumBossThreads(int numBossThreads) {
            this.numBossThreads = numBossThreads;
            return this;
        }

        public Parameters<H> setNumWorkerThreads(int numWorkerThreads) {
            this.numWorkerThreads = numWorkerThreads;
            return this;
        }

        public Parameters<H> setChannelOptions(Map<ChannelOption<Object>, Object> channelOptions) {
            this.channelOptions = channelOptions;
            return this;
        }

        public Parameters<H> setHandler(H handler) {
            this.handler = handler;
            return this;
        }

        public Parameters<H> setLogLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Parameters<H> validate() {
            CommonReader.validate((Object)this);
            return this;
        }

        @Generated
        public String toString() {
            return "TcpServer.Parameters(id=" + this.getId() + ", hostAndPort=" + String.valueOf(this.getHostAndPort()) + ", numBossThreads=" + this.getNumBossThreads() + ", numWorkerThreads=" + this.getNumWorkerThreads() + ", channelOptions=" + String.valueOf(this.getChannelOptions()) + ", handler=" + String.valueOf(this.getHandler()) + ", logLevel=" + String.valueOf(this.getLogLevel()) + ")";
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public HostAndPort getHostAndPort() {
            return this.hostAndPort;
        }

        @Generated
        public int getNumBossThreads() {
            return this.numBossThreads;
        }

        @Generated
        public int getNumWorkerThreads() {
            return this.numWorkerThreads;
        }

        @Generated
        public Map<ChannelOption<Object>, Object> getChannelOptions() {
            return this.channelOptions;
        }

        @Generated
        public H getHandler() {
            return this.handler;
        }

        @Generated
        public LogLevel getLogLevel() {
            return this.logLevel;
        }
    }
}

