/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.io.syslog;

import com.appdynamics.analytics.io.syslog.SyslogMessageListener;
import com.appdynamics.common.util.misc.Listenable;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogTcpMessageHandler
extends ChannelInitializer<SocketChannel>
implements Listenable<SyslogMessageListener> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyslogTcpMessageHandler.class);
    public static final int DEFAULT_MAX_INCOMING_MSG_LENGTH = 3072;
    private final AtomicReference<SyslogMessageListener> listenerRef = new AtomicReference();
    private final int maxIncomingMessageLength;
    private final ByteBuf[] delimiters;
    private final Charset charset;

    public SyslogTcpMessageHandler() {
        this(StandardCharsets.UTF_8);
    }

    public SyslogTcpMessageHandler(Charset charset) {
        this(3072, (ByteBuf[])ArrayUtils.addAll((Object[])Delimiters.nulDelimiter(), (Object[])Delimiters.lineDelimiter()), charset);
    }

    public SyslogTcpMessageHandler(int maxIncomingMessageLength, Charset charset) {
        this(maxIncomingMessageLength, (ByteBuf[])ArrayUtils.addAll((Object[])Delimiters.nulDelimiter(), (Object[])Delimiters.lineDelimiter()), charset);
    }

    public SyslogTcpMessageHandler(int maxIncomingMessageLength, ByteBuf[] delimiters, Charset charset) {
        this.maxIncomingMessageLength = maxIncomingMessageLength;
        this.delimiters = delimiters;
        this.charset = charset;
    }

    public SyslogMessageListener getListener() {
        return this.listenerRef.get();
    }

    public void setListener(SyslogMessageListener listener) {
        this.listenerRef.set(listener);
    }

    public boolean compareAndSetListener(SyslogMessageListener expectedListener, SyslogMessageListener newListener) {
        return this.listenerRef.compareAndSet(expectedListener, newListener);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(this.maxIncomingMessageLength, this.delimiters)});
        p.addLast(new ChannelHandler[]{new StringDecoder(this.charset)});
        p.addLast(new ChannelHandler[]{new StringEncoder(this.charset)});
        p.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<String>(){

            public boolean acceptInboundMessage(Object msg) throws Exception {
                SyslogMessageListener listener = SyslogTcpMessageHandler.this.listenerRef.get();
                return listener != null && super.acceptInboundMessage(msg);
            }

            protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
                log.trace("Server received [{}]", (Object)msg);
                SyslogMessageListener listener = SyslogTcpMessageHandler.this.listenerRef.get();
                if (listener != null) {
                    listener.onMessage(msg);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                log.error("Error occurred", cause);
                ctx.close();
            }
        }});
    }
}

