/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync;

import com.appdynamics.analytics.agent.sync.AnalyticsAgentSyncConfiguration;
import com.appdynamics.analytics.agent.sync.ChannelState;
import com.appdynamics.analytics.agent.sync.configuration.ConfigurationSyncEvent;
import com.appdynamics.analytics.log.shared.agent.ConfigurationConstants;
import com.appdynamics.common.util.event.EventBuses;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.Subscribe;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelStateManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChannelStateManager.class);
    private final EnumMap<ChannelState, ImmutableMap<Boolean, Transition>> stateTransitions;
    private ChannelState currentState;
    private long timeToWaitUntilNextTransition;
    private final long syncFailureMaxInterval;
    private final double syncFailureIntervalMultiplier;
    private boolean localOverrideConfigSyncInterval;
    private long syncSuccessInterval;

    public ChannelStateManager(AnalyticsAgentSyncConfiguration configuration, ChannelState startingState, EventBuses eventBuses) {
        this.stateTransitions = this.makeSyncStateMachine(configuration);
        this.currentState = startingState;
        this.timeToWaitUntilNextTransition = 0L;
        this.syncFailureMaxInterval = configuration.getSyncFailureMaxInterval().toMilliseconds();
        this.syncFailureIntervalMultiplier = configuration.getSyncFailureIntervalMultiplier();
        this.localOverrideConfigSyncInterval = ((Transition)this.stateTransitions.get((Object)ChannelState.CONFIGURATION).get((Object)true)).getCurrentWaitTimeMillis() != 0L;
        this.syncSuccessInterval = configuration.getSyncSuccessInterval().toMilliseconds();
        eventBuses.registerListener("default-event-bus", (Object)this);
    }

    private EnumMap<ChannelState, ImmutableMap<Boolean, Transition>> makeSyncStateMachine(AnalyticsAgentSyncConfiguration configuration) {
        return new EnumMap<ChannelState, ImmutableMap<Boolean, Transition>>((Map<ChannelState, ImmutableMap<Boolean, Transition>>)ImmutableMap.builder().put((Object)ChannelState.REGISTRATION, (Object)ImmutableMap.builder().put((Object)Boolean.FALSE, (Object)new Transition(ChannelState.REGISTRATION, configuration.getSyncFailureBaseInterval().toMilliseconds())).put((Object)Boolean.TRUE, (Object)new Transition(ChannelState.CONFIGURATION, 0L)).build()).put((Object)ChannelState.CONFIGURATION, (Object)ImmutableMap.builder().put((Object)Boolean.FALSE, (Object)new Transition(ChannelState.CONFIGURATION, configuration.getSyncFailureBaseInterval().toMilliseconds())).put((Object)Boolean.TRUE, (Object)new Transition(ChannelState.CONFIGURATION, configuration.getSyncSuccessInterval().toMilliseconds())).build()).build());
    }

    public void transitionToNextState(boolean success) {
        Transition transition = (Transition)this.stateTransitions.get((Object)this.currentState).get((Object)success);
        this.currentState = transition.getToState();
        this.timeToWaitUntilNextTransition = transition.getCurrentWaitTimeMillis();
        if (success) {
            Transition failureTransition = (Transition)this.stateTransitions.get((Object)this.currentState).get((Object)false);
            failureTransition.setCurrentWaitTimeMillis(failureTransition.getBaseWaitTimeMillis());
        } else {
            transition.setCurrentWaitTimeMillis(this.applyExponentialBackoff(this.timeToWaitUntilNextTransition));
        }
    }

    @VisibleForTesting
    long applyExponentialBackoff(long currentWaitTimeMillis) {
        long newTime = (long)((double)currentWaitTimeMillis * this.syncFailureIntervalMultiplier);
        return Math.min(newTime, this.syncFailureMaxInterval);
    }

    @Subscribe
    @VisibleForTesting
    void onNewConfigurationSyncEvent(ConfigurationSyncEvent configurationSyncEvent) {
        Preconditions.checkNotNull((Object)configurationSyncEvent, (Object)"configurationSyncEvent can't be null");
        Preconditions.checkNotNull((Object)configurationSyncEvent.getAgentConfiguration(), (Object)"agentConfiguration can't be null");
        long configurationSyncIntervalMillis = configurationSyncEvent.getAgentConfiguration().getConfigSyncIntervalMillis();
        long configurationSyncIntervalMinMillis = configurationSyncEvent.getAgentConfiguration().getConfigSyncIntervalMinMillis();
        long configurationSyncIntervalMaxMillis = configurationSyncEvent.getAgentConfiguration().getConfigSyncIntervalMaxMillis();
        Transition transition = (Transition)this.stateTransitions.get((Object)ChannelState.CONFIGURATION).get((Object)true);
        if (!this.localOverrideConfigSyncInterval) {
            transition.setCurrentWaitTimeMillis(configurationSyncIntervalMillis);
        } else {
            if (configurationSyncIntervalMinMillis != 0L && this.syncSuccessInterval < configurationSyncIntervalMinMillis) {
                log.warn("The configured configuration synchronization interval [{}] millisecond is smaller that the minimum requirement. Setting the synchronization interval to be [{}].", (Object)this.syncSuccessInterval, (Object)configurationSyncIntervalMinMillis);
                transition.setCurrentWaitTimeMillis(configurationSyncIntervalMinMillis);
            } else if (configurationSyncIntervalMaxMillis != 0L && this.syncSuccessInterval > configurationSyncIntervalMaxMillis) {
                log.warn("The configured configuration synchronization interval [{}] millisecond is greater that the maximum allowed value. Setting the synchronization interval to be [{}].", (Object)this.syncSuccessInterval, (Object)configurationSyncIntervalMaxMillis);
                transition.setCurrentWaitTimeMillis(configurationSyncIntervalMaxMillis);
            }
            if (configurationSyncEvent.getAgentConfiguration().getLscConfigHash() != ConfigurationConstants.CONFIG_NO_CHANGE_SENTINEL.longValue()) {
                log.info("The controller - analytics agent synchronization interval updated to [{}]", (Object)transition.getCurrentWaitTimeMillis());
            }
        }
    }

    @Generated
    public ChannelState getCurrentState() {
        return this.currentState;
    }

    @Generated
    public long getTimeToWaitUntilNextTransition() {
        return this.timeToWaitUntilNextTransition;
    }

    private static class Transition {
        private final ChannelState toState;
        private long baseWaitTimeMillis;
        private long currentWaitTimeMillis;

        public Transition(ChannelState toState, long baseWaitTimeMillis) {
            this.toState = toState;
            this.baseWaitTimeMillis = baseWaitTimeMillis;
            this.currentWaitTimeMillis = baseWaitTimeMillis;
        }

        @Generated
        public ChannelState getToState() {
            return this.toState;
        }

        @Generated
        public long getBaseWaitTimeMillis() {
            return this.baseWaitTimeMillis;
        }

        @Generated
        public long getCurrentWaitTimeMillis() {
            return this.currentWaitTimeMillis;
        }

        @Generated
        public void setBaseWaitTimeMillis(long baseWaitTimeMillis) {
            this.baseWaitTimeMillis = baseWaitTimeMillis;
        }

        @Generated
        public void setCurrentWaitTimeMillis(long currentWaitTimeMillis) {
            this.currentWaitTimeMillis = currentWaitTimeMillis;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Transition)) {
                return false;
            }
            Transition other = (Transition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBaseWaitTimeMillis() != other.getBaseWaitTimeMillis()) {
                return false;
            }
            if (this.getCurrentWaitTimeMillis() != other.getCurrentWaitTimeMillis()) {
                return false;
            }
            ChannelState this$toState = this.getToState();
            ChannelState other$toState = other.getToState();
            return !(this$toState == null ? other$toState != null : !((Object)((Object)this$toState)).equals((Object)other$toState));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Transition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $baseWaitTimeMillis = this.getBaseWaitTimeMillis();
            result = result * 59 + (int)($baseWaitTimeMillis >>> 32 ^ $baseWaitTimeMillis);
            long $currentWaitTimeMillis = this.getCurrentWaitTimeMillis();
            result = result * 59 + (int)($currentWaitTimeMillis >>> 32 ^ $currentWaitTimeMillis);
            ChannelState $toState = this.getToState();
            result = result * 59 + ($toState == null ? 43 : ((Object)((Object)$toState)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChannelStateManager.Transition(toState=" + String.valueOf((Object)this.getToState()) + ", baseWaitTimeMillis=" + this.getBaseWaitTimeMillis() + ", currentWaitTimeMillis=" + this.getCurrentWaitTimeMillis() + ")";
        }
    }
}

