/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync;

import com.appdynamics.analytics.agent.sync.AgentTags;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentTagManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentTagManager.class);
    private Map<String, String> tags;

    public AgentTagManager(Map<String, String> initialTags) {
        this.tags = initialTags;
    }

    public AgentTags getCurrentAgentTags() {
        this.ensureTagsUptodate();
        return new AgentTags(Collections.unmodifiableMap(this.tags));
    }

    private void ensureTagsUptodate() {
        this.updateIpAddressTag();
    }

    private void updateIpAddressTag() {
        try {
            String ipAddress = InetAddress.getLocalHost().getHostAddress();
            this.tags.put("ip-address", ipAddress);
        }
        catch (UnknownHostException e) {
            log.error("Unable to extract IP out of host machine", (Throwable)e);
            this.tags.put("ip-address", "na");
        }
    }
}

