/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync;

import com.appdynamics.analytics.agent.sync.AgentHealth;
import com.appdynamics.analytics.agent.sync.HealthCheckHelper;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.health.MeteredHealthCheck;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentHealthManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentHealthManager.class);
    private final ConsolidatedHealthCheck healthCheck;
    private final AgentHealth agentHealth;
    private final String bizTxnsHealthCheckName;
    private final String logsHealthCheckName;
    private final String eventServiceConnectionCheckName;
    private double healthErrorThreshold;

    public AgentHealthManager(String bizTxnsHealthCheckName, String logsHealthCheckName, String eventServiceConnectionCheckName, ConsolidatedHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
        this.bizTxnsHealthCheckName = bizTxnsHealthCheckName;
        this.logsHealthCheckName = logsHealthCheckName;
        this.eventServiceConnectionCheckName = eventServiceConnectionCheckName;
        this.agentHealth = new AgentHealth();
        this.healthErrorThreshold = 0.005;
    }

    public AgentHealth extractAgentHealth() {
        Map healthStatus = this.healthCheck.getComponents();
        HealthCheckable bizTxnsHealth = (HealthCheckable)healthStatus.get(this.bizTxnsHealthCheckName);
        HealthCheckable logsHealth = (HealthCheckable)healthStatus.get(this.logsHealthCheckName);
        HealthCheckable eventServiceConnectionHealth = (HealthCheckable)healthStatus.get(this.eventServiceConnectionCheckName);
        boolean bizTxnsHealthy = true;
        boolean logsHealthy = true;
        if (eventServiceConnectionHealth != null) {
            if (eventServiceConnectionHealth.check().isHealthy()) {
                MeteredHealthCheck meteredHealthCheckLog;
                MeteredHealthCheck meteredHealthCheckBT;
                if (bizTxnsHealth instanceof MeteredHealthCheck && !HealthCheckHelper.isHealthy((meteredHealthCheckBT = (MeteredHealthCheck)bizTxnsHealth).getMeterError().getFiveMinuteRate())) {
                    bizTxnsHealthy = false;
                    log.debug("Agent pipeline for bizTxns unhealthy.");
                }
                if (logsHealth instanceof MeteredHealthCheck && !HealthCheckHelper.isHealthy((meteredHealthCheckLog = (MeteredHealthCheck)logsHealth).getMeterError().getFiveMinuteRate())) {
                    logsHealthy = false;
                    log.debug("Agent pipeline for logs unhealthy.");
                }
            } else {
                bizTxnsHealthy = false;
                logsHealthy = false;
                log.debug("Agent connection to event service unhealthy.");
            }
        } else {
            bizTxnsHealthy = false;
            logsHealthy = false;
            log.debug("Unable to extract agent health information.");
        }
        this.agentHealth.setBizTxnsHealthy(bizTxnsHealthy);
        this.agentHealth.setLogsHealthy(logsHealthy);
        return this.agentHealth;
    }

    public void setHealthErrorThreshold(double healthErrorThreshold) {
        this.healthErrorThreshold = healthErrorThreshold == 0.0 ? 0.005 : healthErrorThreshold;
    }

    public double getHealthErrorThreshold() {
        return this.healthErrorThreshold;
    }
}

