/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source.tail;

import com.appdynamics.analytics.agent.source.tail.NativePlatform;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsNativePlatform
extends NativePlatform {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsNativePlatform.class);
    private Kernel32Library kernel32Instance = (Kernel32Library)Native.loadLibrary((String)"kernel32", Kernel32Library.class, (Map)W32APIOptions.UNICODE_OPTIONS);

    protected WindowsNativePlatform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getFileSize(String fileName) {
        long fileSize = -1L;
        WinNT.HANDLE hFile = null;
        WinNT.HANDLE nullHandle = new WinNT.HANDLE();
        hFile = this.kernel32Instance.CreateFile(fileName, 0, 7, Pointer.NULL, 3, 128, nullHandle);
        if (hFile == null || WinBase.INVALID_HANDLE_VALUE.getPointer().equals((Object)hFile.getPointer())) {
            String pointerValue = hFile != null ? hFile.getPointer().toString() : "";
            this.logGetLastError(String.format("opening file hf=%s", pointerValue), fileName);
        } else {
            int type = this.kernel32Instance.GetFileType(hFile);
            if ((long)type != 3L) {
                NativeLongByReference lpFileSize = new NativeLongByReference(new NativeLong());
                boolean fileSizePassed = this.kernel32Instance.GetFileSizeEx(hFile, lpFileSize);
                fileSize = lpFileSize.getValue().longValue();
                if (!fileSizePassed) {
                    this.logGetLastError(String.format("retrieve file size hf=%s", hFile.getPointer()), fileName);
                    fileSize = -1L;
                }
            } else {
                log.error("Couldn't open file [{}] because it is a piped file.", (Object)fileName);
            }
        }
        if (hFile == null) return fileSize;
        try {
            this.kernel32Instance.CloseHandle(hFile);
            return fileSize;
        }
        catch (Exception e) {
            log.error("An exception was thrown while closing the handle for [{}]", (Object)fileName, (Object)e);
        }
        return fileSize;
        catch (Throwable e) {
            try {
                log.error("Failed to open file [{}] to get file size.", (Object)fileName, (Object)e);
                fileSize = -1L;
                if (hFile == null) return fileSize;
            }
            catch (Throwable throwable) {
                if (hFile == null) throw throwable;
                try {
                    this.kernel32Instance.CloseHandle(hFile);
                    throw throwable;
                }
                catch (Exception e2) {
                    log.error("An exception was thrown while closing the handle for [{}]", (Object)fileName, (Object)e2);
                }
                throw throwable;
            }
            try {
                this.kernel32Instance.CloseHandle(hFile);
                return fileSize;
            }
            catch (Exception e3) {
                log.error("An exception was thrown while closing the handle for [{}]", (Object)fileName, (Object)e3);
            }
            return fileSize;
        }
    }

    public void logGetLastError(String contextMessage, String fileName) {
        int errorCode = this.kernel32Instance.GetLastError();
        String message = this.formatMessage(errorCode);
        if (message != null) {
            log.error("Error code [{}] with message [{}] in context [{}] opening file [{}]", new Object[]{errorCode, message, contextMessage, fileName});
        } else {
            log.error("Error code [{}] opening file [{}] in context [{}]", new Object[]{errorCode, fileName, contextMessage});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String formatMessage(int errorCode) {
        try {
            PointerByReference buffer = new PointerByReference();
            int nLen = this.kernel32Instance.FormatMessage(4864, null, errorCode, 0, buffer, 0, null);
            if (nLen == 0) {
                int formatErrorCode = this.kernel32Instance.GetLastError();
                log.error("Failed to get format message with error code [{}]", (Object)formatErrorCode);
                return null;
            }
            Pointer ptr = buffer.getValue();
            try {
                String formatMessage = ptr.getWideString(0L);
                String string = formatMessage.trim();
                return string;
            }
            finally {
                this.freeLocalMemory(ptr);
            }
        }
        catch (Exception e) {
            log.error("Failed to format message.", (Throwable)e);
        }
        return null;
    }

    private void freeLocalMemory(Pointer ptr) {
        try {
            Pointer res = this.kernel32Instance.LocalFree(ptr);
            if (res != null) {
                int formatErrorCode = this.kernel32Instance.GetLastError();
                log.error("Failed to get format message with error code [{}] in freeLocalMemory.", (Object)formatErrorCode);
            }
        }
        catch (Exception e) {
            log.error("Failed to release memory.", (Throwable)e);
        }
    }

    public static interface Kernel32Library
    extends Library {
        public static final long FILE_TYPE_PIPE = 3L;

        public int GetLastError();

        public int FormatMessage(int var1, Pointer var2, int var3, int var4, PointerByReference var5, int var6, Pointer var7);

        public Pointer LocalFree(Pointer var1);

        public WinNT.HANDLE CreateFile(String var1, int var2, int var3, Pointer var4, int var5, int var6, WinNT.HANDLE var7);

        public int GetFileType(WinNT.HANDLE var1);

        public boolean CloseHandle(WinNT.HANDLE var1);

        public boolean GetFileSizeEx(WinNT.HANDLE var1, NativeLongByReference var2);
    }
}

