/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source.tail;

import com.appdynamics.analytics.agent.input.tail.TailLogInputConfiguration;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.pipeline.xform.grok.NonGrokPattern;
import com.appdynamics.common.io.file.FilePathConfiguration;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class TailLogSourceConfiguration
extends LogSourceConfiguration {
    public static final int DEFAULT_THREAD_POOL_SIZE = 5;
    @Valid
    @NotNull
    FilePathConfiguration sourcePath;
    @Valid
    @NotNull
    TailLogInputConfiguration tailLogInputConfiguration;
    @Valid
    @NotNull
    TimeUnitConfiguration directoryPollingInterval = new TimeUnitConfiguration(2000L, TimeUnit.MILLISECONDS);
    @Valid
    @NotNull
    TimeUnitConfiguration hardDirectoryPollingInterval = new TimeUnitConfiguration(120000L, TimeUnit.MILLISECONDS);
    @Valid
    @NotNull
    TimeUnitConfiguration stopIdleInputsTimeout = new TimeUnitConfiguration(30L, TimeUnit.SECONDS);
    @Valid
    @NotNull
    TimeUnitConfiguration stopFailedInputsWaitTime = new TimeUnitConfiguration(120L, TimeUnit.SECONDS);
    @Valid
    @NotNull
    TimeUnitConfiguration discardTailingStateTimeout = new TimeUnitConfiguration(30L, TimeUnit.DAYS);
    @Valid
    @NotNull
    TimeUnitConfiguration discardTailingStateCheckInterval = new TimeUnitConfiguration(1L, TimeUnit.HOURS);
    @Valid
    @NotNull
    Boolean collectCompressed = false;
    @Min(value=1L)
    @Min(value=1L) int maximumInputPoolSize = 5;

    public TailLogSourceConfiguration() {
    }

    @JsonCreator
    public TailLogSourceConfiguration(@JsonProperty(value="name") String name, @JsonProperty(value="id") String id, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="extractedFieldPatterns") Set<NonGrokPattern> extractedFieldPatterns, @JsonProperty(value="watermarkPath") FilePathConfiguration sourcePath, @JsonProperty(value="tailLogInputConfiguration") TailLogInputConfiguration tailLogInputConfiguration, @JsonProperty(value="directoryPollingInterval") TimeUnitConfiguration directoryPollingInterval, @JsonProperty(value="hardDirectoryPollingInterval") TimeUnitConfiguration hardDirectoryPollingInterval, @JsonProperty(value="stopIdleInputsTimeout") TimeUnitConfiguration stopIdleInputsTimeout, @JsonProperty(value="discardTailingStateTimeout") TimeUnitConfiguration discardTailingStateTimeout, @JsonProperty(value="discardTailingStateCheckInterval") TimeUnitConfiguration discardTailingStateCheckInterval, @JsonProperty(value="maximumInputPoolSize") int maximumInputPoolSize, @JsonProperty(value="collectLastNHours") int collectLastNHours, @JsonProperty(value="collectCompressed") boolean includeCollectCompressed, @JsonProperty(value="duplicateTimestampCorrection") boolean duplicateTimestampCorrection) {
        super(name, id, enabled, sourceType, extractedFieldPatterns, collectLastNHours, duplicateTimestampCorrection);
        this.sourcePath = sourcePath;
        this.tailLogInputConfiguration = tailLogInputConfiguration;
        this.directoryPollingInterval = directoryPollingInterval;
        this.hardDirectoryPollingInterval = hardDirectoryPollingInterval;
        this.stopIdleInputsTimeout = stopIdleInputsTimeout;
        this.discardTailingStateTimeout = discardTailingStateTimeout;
        this.discardTailingStateCheckInterval = discardTailingStateCheckInterval;
        this.maximumInputPoolSize = maximumInputPoolSize;
        this.collectCompressed = includeCollectCompressed;
    }

    @Generated
    public FilePathConfiguration getSourcePath() {
        return this.sourcePath;
    }

    @Generated
    public TailLogInputConfiguration getTailLogInputConfiguration() {
        return this.tailLogInputConfiguration;
    }

    @Generated
    public TimeUnitConfiguration getDirectoryPollingInterval() {
        return this.directoryPollingInterval;
    }

    @Generated
    public TimeUnitConfiguration getHardDirectoryPollingInterval() {
        return this.hardDirectoryPollingInterval;
    }

    @Generated
    public TimeUnitConfiguration getStopIdleInputsTimeout() {
        return this.stopIdleInputsTimeout;
    }

    @Generated
    public TimeUnitConfiguration getStopFailedInputsWaitTime() {
        return this.stopFailedInputsWaitTime;
    }

    @Generated
    public TimeUnitConfiguration getDiscardTailingStateTimeout() {
        return this.discardTailingStateTimeout;
    }

    @Generated
    public TimeUnitConfiguration getDiscardTailingStateCheckInterval() {
        return this.discardTailingStateCheckInterval;
    }

    @Generated
    public Boolean getCollectCompressed() {
        return this.collectCompressed;
    }

    @Generated
    public int getMaximumInputPoolSize() {
        return this.maximumInputPoolSize;
    }

    @Generated
    public void setSourcePath(FilePathConfiguration sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Generated
    public void setTailLogInputConfiguration(TailLogInputConfiguration tailLogInputConfiguration) {
        this.tailLogInputConfiguration = tailLogInputConfiguration;
    }

    @Generated
    public void setDirectoryPollingInterval(TimeUnitConfiguration directoryPollingInterval) {
        this.directoryPollingInterval = directoryPollingInterval;
    }

    @Generated
    public void setHardDirectoryPollingInterval(TimeUnitConfiguration hardDirectoryPollingInterval) {
        this.hardDirectoryPollingInterval = hardDirectoryPollingInterval;
    }

    @Generated
    public void setStopIdleInputsTimeout(TimeUnitConfiguration stopIdleInputsTimeout) {
        this.stopIdleInputsTimeout = stopIdleInputsTimeout;
    }

    @Generated
    public void setStopFailedInputsWaitTime(TimeUnitConfiguration stopFailedInputsWaitTime) {
        this.stopFailedInputsWaitTime = stopFailedInputsWaitTime;
    }

    @Generated
    public void setDiscardTailingStateTimeout(TimeUnitConfiguration discardTailingStateTimeout) {
        this.discardTailingStateTimeout = discardTailingStateTimeout;
    }

    @Generated
    public void setDiscardTailingStateCheckInterval(TimeUnitConfiguration discardTailingStateCheckInterval) {
        this.discardTailingStateCheckInterval = discardTailingStateCheckInterval;
    }

    @Generated
    public void setCollectCompressed(Boolean collectCompressed) {
        this.collectCompressed = collectCompressed;
    }

    @Generated
    public void setMaximumInputPoolSize(int maximumInputPoolSize) {
        this.maximumInputPoolSize = maximumInputPoolSize;
    }

    @Override
    @Generated
    public String toString() {
        return "TailLogSourceConfiguration(sourcePath=" + String.valueOf(this.getSourcePath()) + ", tailLogInputConfiguration=" + String.valueOf(this.getTailLogInputConfiguration()) + ", directoryPollingInterval=" + String.valueOf(this.getDirectoryPollingInterval()) + ", hardDirectoryPollingInterval=" + String.valueOf(this.getHardDirectoryPollingInterval()) + ", stopIdleInputsTimeout=" + String.valueOf(this.getStopIdleInputsTimeout()) + ", stopFailedInputsWaitTime=" + String.valueOf(this.getStopFailedInputsWaitTime()) + ", discardTailingStateTimeout=" + String.valueOf(this.getDiscardTailingStateTimeout()) + ", discardTailingStateCheckInterval=" + String.valueOf(this.getDiscardTailingStateCheckInterval()) + ", collectCompressed=" + this.getCollectCompressed() + ", maximumInputPoolSize=" + this.getMaximumInputPoolSize() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TailLogSourceConfiguration)) {
            return false;
        }
        TailLogSourceConfiguration other = (TailLogSourceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaximumInputPoolSize() != other.getMaximumInputPoolSize()) {
            return false;
        }
        Boolean this$collectCompressed = this.getCollectCompressed();
        Boolean other$collectCompressed = other.getCollectCompressed();
        if (this$collectCompressed == null ? other$collectCompressed != null : !((Object)this$collectCompressed).equals(other$collectCompressed)) {
            return false;
        }
        FilePathConfiguration this$sourcePath = this.getSourcePath();
        FilePathConfiguration other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
            return false;
        }
        TailLogInputConfiguration this$tailLogInputConfiguration = this.getTailLogInputConfiguration();
        TailLogInputConfiguration other$tailLogInputConfiguration = other.getTailLogInputConfiguration();
        if (this$tailLogInputConfiguration == null ? other$tailLogInputConfiguration != null : !((Object)this$tailLogInputConfiguration).equals(other$tailLogInputConfiguration)) {
            return false;
        }
        TimeUnitConfiguration this$directoryPollingInterval = this.getDirectoryPollingInterval();
        TimeUnitConfiguration other$directoryPollingInterval = other.getDirectoryPollingInterval();
        if (this$directoryPollingInterval == null ? other$directoryPollingInterval != null : !this$directoryPollingInterval.equals(other$directoryPollingInterval)) {
            return false;
        }
        TimeUnitConfiguration this$hardDirectoryPollingInterval = this.getHardDirectoryPollingInterval();
        TimeUnitConfiguration other$hardDirectoryPollingInterval = other.getHardDirectoryPollingInterval();
        if (this$hardDirectoryPollingInterval == null ? other$hardDirectoryPollingInterval != null : !this$hardDirectoryPollingInterval.equals(other$hardDirectoryPollingInterval)) {
            return false;
        }
        TimeUnitConfiguration this$stopIdleInputsTimeout = this.getStopIdleInputsTimeout();
        TimeUnitConfiguration other$stopIdleInputsTimeout = other.getStopIdleInputsTimeout();
        if (this$stopIdleInputsTimeout == null ? other$stopIdleInputsTimeout != null : !this$stopIdleInputsTimeout.equals(other$stopIdleInputsTimeout)) {
            return false;
        }
        TimeUnitConfiguration this$stopFailedInputsWaitTime = this.getStopFailedInputsWaitTime();
        TimeUnitConfiguration other$stopFailedInputsWaitTime = other.getStopFailedInputsWaitTime();
        if (this$stopFailedInputsWaitTime == null ? other$stopFailedInputsWaitTime != null : !this$stopFailedInputsWaitTime.equals(other$stopFailedInputsWaitTime)) {
            return false;
        }
        TimeUnitConfiguration this$discardTailingStateTimeout = this.getDiscardTailingStateTimeout();
        TimeUnitConfiguration other$discardTailingStateTimeout = other.getDiscardTailingStateTimeout();
        if (this$discardTailingStateTimeout == null ? other$discardTailingStateTimeout != null : !this$discardTailingStateTimeout.equals(other$discardTailingStateTimeout)) {
            return false;
        }
        TimeUnitConfiguration this$discardTailingStateCheckInterval = this.getDiscardTailingStateCheckInterval();
        TimeUnitConfiguration other$discardTailingStateCheckInterval = other.getDiscardTailingStateCheckInterval();
        return !(this$discardTailingStateCheckInterval == null ? other$discardTailingStateCheckInterval != null : !this$discardTailingStateCheckInterval.equals(other$discardTailingStateCheckInterval));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TailLogSourceConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMaximumInputPoolSize();
        Boolean $collectCompressed = this.getCollectCompressed();
        result = result * 59 + ($collectCompressed == null ? 43 : ((Object)$collectCompressed).hashCode());
        FilePathConfiguration $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
        TailLogInputConfiguration $tailLogInputConfiguration = this.getTailLogInputConfiguration();
        result = result * 59 + ($tailLogInputConfiguration == null ? 43 : ((Object)$tailLogInputConfiguration).hashCode());
        TimeUnitConfiguration $directoryPollingInterval = this.getDirectoryPollingInterval();
        result = result * 59 + ($directoryPollingInterval == null ? 43 : $directoryPollingInterval.hashCode());
        TimeUnitConfiguration $hardDirectoryPollingInterval = this.getHardDirectoryPollingInterval();
        result = result * 59 + ($hardDirectoryPollingInterval == null ? 43 : $hardDirectoryPollingInterval.hashCode());
        TimeUnitConfiguration $stopIdleInputsTimeout = this.getStopIdleInputsTimeout();
        result = result * 59 + ($stopIdleInputsTimeout == null ? 43 : $stopIdleInputsTimeout.hashCode());
        TimeUnitConfiguration $stopFailedInputsWaitTime = this.getStopFailedInputsWaitTime();
        result = result * 59 + ($stopFailedInputsWaitTime == null ? 43 : $stopFailedInputsWaitTime.hashCode());
        TimeUnitConfiguration $discardTailingStateTimeout = this.getDiscardTailingStateTimeout();
        result = result * 59 + ($discardTailingStateTimeout == null ? 43 : $discardTailingStateTimeout.hashCode());
        TimeUnitConfiguration $discardTailingStateCheckInterval = this.getDiscardTailingStateCheckInterval();
        result = result * 59 + ($discardTailingStateCheckInterval == null ? 43 : $discardTailingStateCheckInterval.hashCode());
        return result;
    }
}

