/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source.tail;

import com.appdynamics.analytics.agent.input.tail.FileInfo;
import com.appdynamics.analytics.agent.input.tail.FileSignature;
import com.appdynamics.analytics.agent.input.tail.TailFileState;
import com.appdynamics.analytics.agent.source.tail.DirectoryPoller;
import com.appdynamics.analytics.pipeline.xform.time.TimestampFilterHelpers;
import com.appdynamics.common.util.datetime.TimeKeeper;
import com.google.common.base.Function;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInputScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileInputScanner.class);
    private final DirectoryPoller directoryPoller;
    private final Map<FileSignature, TailFileState> partialIdToTailStates;
    private final Map<FileSignature, TailFileState> fileIdToTailStates;
    private final Function<TailFileState, Boolean> ensureInputExists;
    private final long collectLastMilliseconds;
    private long initialScan;

    public FileInputScanner(DirectoryPoller directoryPoller, Map<FileSignature, TailFileState> partialIdToTailStates, Map<FileSignature, TailFileState> fileIdToTailStates, Function<TailFileState, Boolean> ensureInputExists, int collectLastNHours) {
        this.directoryPoller = directoryPoller;
        this.partialIdToTailStates = partialIdToTailStates;
        this.fileIdToTailStates = fileIdToTailStates;
        this.ensureInputExists = ensureInputExists;
        this.collectLastMilliseconds = TimeUnit.HOURS.toMillis(collectLastNHours);
        this.initialScan = System.currentTimeMillis();
    }

    private TailFileState getTailFileStateFromFileInfo(FileInfo fileInfo) throws IOException {
        TailFileState tailState = null;
        FileSignature fileId = fileInfo.getFileSignature();
        tailState = fileId.isComplete() && this.fileIdToTailStates.containsKey(fileId) ? this.fileIdToTailStates.get(fileId) : this.lookupTailStateByPartialSignature(fileInfo);
        return tailState;
    }

    private TailFileState lookupTailStateByPartialSignature(FileInfo fileInfo) throws IOException {
        TailFileState tailState = null;
        FileSignature partialSignature = null;
        for (TailFileState candidate : this.partialIdToTailStates.values()) {
            int signatureSize = candidate.getSignature().getSize();
            long size = fileInfo.getSize();
            if (fileInfo.isCompressed()) {
                size = candidate.getDecompressedSize() == -1L ? fileInfo.getDecompressedSize() : candidate.getDecompressedSize();
            }
            if (size < (long)signatureSize || !(partialSignature = fileInfo.getFileSignature(signatureSize)).equals(candidate.getSignature())) continue;
            tailState = candidate;
            break;
        }
        if (tailState != null && fileInfo.getFileSignature().isComplete()) {
            this.partialIdToTailStates.remove(partialSignature);
            tailState.setSignature(fileInfo.getFileSignature());
            this.fileIdToTailStates.put(fileInfo.getFileSignature(), tailState);
        }
        return tailState;
    }

    private TailFileState addNewTailFileStateFromFileInfo(FileInfo fileInfo) throws IOException {
        TailFileState tailState = new TailFileState(fileInfo);
        if (fileInfo.getFileSignature().isComplete()) {
            this.fileIdToTailStates.put(fileInfo.getFileSignature(), tailState);
        } else {
            this.partialIdToTailStates.put(fileInfo.getFileSignature(), tailState);
        }
        return tailState;
    }

    public void clearFileCacheWithFileSignature(String fileSignature) {
        this.directoryPoller.clearFileCacheWithFileSignature(fileSignature);
    }

    public void scan() {
        this.scan(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void scan(boolean doHardCheck) {
        FileInfo[] files = this.directoryPoller.getFiles(doHardCheck);
        log.debug("Starting ... checking {} files.", (Object)files.length);
        long lastScanned = TimeKeeper.currentUtcTime().getMillis();
        for (FileInfo fileInfo : files) {
            TailFileState tailState;
            block23: {
                tailState = null;
                tailState = this.getTailFileStateFromFileInfo(fileInfo);
                if (tailState == null) {
                    tailState = this.addNewTailFileStateFromFileInfo(fileInfo);
                } else {
                    tailState.setLastScanned(lastScanned);
                }
                if (!TimestampFilterHelpers.shouldDiscard((long)this.collectLastMilliseconds, (long)lastScanned, (long)fileInfo.getLastModified())) {
                    if (this.moreBytesToRead(fileInfo, tailState)) {
                        tailState.updateLastModifiedTime(fileInfo);
                        if (((Boolean)this.ensureInputExists.apply((Object)tailState)).booleanValue()) {
                            log.info("Added file tailer for [{}] with file signature [{}]", (Object)fileInfo.getFilename(), (Object)fileInfo.getFileSignature());
                        } else if (!tailState.getFilename().equals(fileInfo.getFilename()) && log.isDebugEnabled()) {
                            log.debug("File tailer for [{}] was not created because there already exists a file tailer associated to a file originally named [{}] with the same tail file state", (Object)fileInfo.getFilename(), (Object)tailState.getFilename());
                        }
                    }
                    break block23;
                }
                log.debug("Skipped file [{}] as it contains logs older than [{}] hours.", (Object)fileInfo.getFilename(), (Object)TimeUnit.MILLISECONDS.toHours(this.collectLastMilliseconds));
            }
            try {
                fileInfo.close();
                if (tailState == null) continue;
                tailState.close();
            }
            catch (IOException except) {
                log.error(String.format("Failed to close handle on file [%s].", fileInfo.getFilename()), (Throwable)except);
            }
            continue;
            catch (ClosedByInterruptException except) {
                log.info(String.format(" Thread interrupted for file [%s]. It will be skipped for now.", fileInfo.getFilename()));
                try {
                    fileInfo.close();
                    if (tailState == null) continue;
                    tailState.close();
                }
                catch (IOException except2) {
                    log.error(String.format("Failed to close handle on file [%s].", fileInfo.getFilename()), (Throwable)except2);
                }
                continue;
            }
            catch (IOException except2) {
                log.error(String.format("Encountered an error with file [%s].  It will be skipped.", fileInfo.getFilename()), (Throwable)except2);
                {
                    catch (Throwable throwable) {
                        try {
                            fileInfo.close();
                            if (tailState != null) {
                                tailState.close();
                            }
                        }
                        catch (IOException except3) {
                            log.error(String.format("Failed to close handle on file [%s].", fileInfo.getFilename()), (Throwable)except3);
                        }
                        throw throwable;
                    }
                }
                try {
                    fileInfo.close();
                    if (tailState == null) continue;
                    tailState.close();
                }
                catch (IOException except4) {
                    log.error(String.format("Failed to close handle on file [%s].", fileInfo.getFilename()), (Throwable)except4);
                }
            }
        }
    }

    private boolean moreBytesToRead(FileInfo fileInfo, TailFileState tailFileState) {
        if (tailFileState.getLastReadPosition() < fileInfo.getSize()) {
            return true;
        }
        if (fileInfo.isCompressed()) {
            long decompressedSize = tailFileState.getDecompressedSize();
            if (decompressedSize <= 0L) {
                try {
                    decompressedSize = fileInfo.getDecompressedSize();
                    tailFileState.setDecompressedSize(decompressedSize);
                }
                catch (IOException e) {
                    log.error("Could not calculate decompressed size of file [{}]", (Object)fileInfo.getFilename(), (Object)e);
                    return false;
                }
            }
            if (tailFileState.getLastReadPosition() < decompressedSize) {
                return true;
            }
        }
        return false;
    }

    @Generated
    public long getInitialScan() {
        return this.initialScan;
    }
}

